/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.xml;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.api.longop.ILongOperationRunner;
import org.eclipse.platform.discovery.util.api.xml.IXmlRepresentable;
import org.eclipse.platform.discovery.util.internal.longop.CurrentThreadOperationRunner;
import org.eclipse.platform.discovery.util.internal.xml.CollectionTransformer;
import org.eclipse.platform.discovery.util.internal.xml.Messages;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class CollectionTransformerProgressMonitorTest
extends MockObjectTestCase {
    private Mock<IProgressMonitor> monitor;
    private Mock<IXmlRepresentable> xmlRepr1;
    private Mock<IXmlRepresentable> xmlRepr2;
    private CollectionTransformer transformer;

    protected void setUp() throws Exception {
        this.monitor = this.mock(IProgressMonitor.class);
        this.transformer = new CollectionTransformer();
    }

    public void testWithoutPm() {
        this.xmlRepr1 = this.xmlReprWithPm(false);
        this.xmlRepr2 = this.xmlReprWithPm(false);
        this.transformer.transform(this.testIterator(), (ILongOperationRunner)new CurrentThreadOperationRunner((IProgressMonitor)this.monitor.proxy()));
    }

    public void testWithPmStartedOnce1() {
        this.monitor.expects(this.once()).method("beginTask").with((Constraint)this.eq(Messages.CollectionTransformer_TRANSFORMING_TO_XML), (Constraint)this.eq(-1));
        this.monitor.expects(this.once()).method("done");
        this.xmlRepr1 = this.xmlReprWithPm(true);
        this.xmlRepr2 = this.xmlReprWithPm(false);
        this.transformer.transform(this.testIterator(), (ILongOperationRunner)new CurrentThreadOperationRunner((IProgressMonitor)this.monitor.proxy()));
    }

    public void testWithPmStartedOnce2() {
        this.monitor.expects(this.once()).method("beginTask").with((Constraint)this.eq(Messages.CollectionTransformer_TRANSFORMING_TO_XML), (Constraint)this.eq(-1));
        this.monitor.expects(this.once()).method("done");
        this.xmlRepr1 = this.xmlReprWithPm(false);
        this.xmlRepr2 = this.xmlReprWithPm(true);
        this.transformer.transform(this.testIterator(), (ILongOperationRunner)new CurrentThreadOperationRunner((IProgressMonitor)this.monitor.proxy()));
    }

    public void testWithPmStartedTwice() {
        this.monitor.expects(this.once()).method("beginTask").with((Constraint)this.eq(Messages.CollectionTransformer_TRANSFORMING_TO_XML), (Constraint)this.eq(-1));
        this.monitor.expects(this.once()).method("done");
        this.xmlRepr1 = this.xmlReprWithPm(true);
        this.xmlRepr2 = this.xmlReprWithPm(true);
        this.transformer.transform(this.testIterator(), (ILongOperationRunner)new CurrentThreadOperationRunner((IProgressMonitor)this.monitor.proxy()));
    }

    private Mock<IXmlRepresentable> xmlReprWithPm(final boolean willUsePm) {
        Mock result = this.mock(IXmlRepresentable.class);
        result.stubs().method("toStringXml").will(new Stub(){

            public Object invoke(Invocation arg0) throws Throwable {
                if (willUsePm) {
                    ((SubProgressMonitor)arg0.parameterValues.get(0)).beginTask("", 0);
                }
                return "test";
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        });
        return result;
    }

    private Iterator<?> testIterator() {
        return Arrays.asList((IXmlRepresentable)this.xmlRepr1.proxy(), (IXmlRepresentable)this.xmlRepr2.proxy()).iterator();
    }
}

