/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.AttributeContractTests;
import org.eclipse.platform.discovery.util.internal.property.IProperty;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;

public class PropertyValueTests
extends AttributeContractTests<Object, Object> {
    @Override
    protected Object getAttributeValue(IProperty<Object> p) {
        return p.get();
    }

    @Override
    protected Object getDefaultValue() {
        return null;
    }

    @Override
    protected Object newAttributeDifferentThen(Object differentThen) {
        return new Object();
    }

    @Override
    protected Object newNonDefaultAttributeValue() {
        return new Object();
    }

    @Override
    protected IProperty<Object> newTarget() {
        return new Property();
    }

    @Override
    protected void registerAttributeListener(IProperty<Object> target, IPropertyAttributeListener<Object> listener, boolean current) {
        target.registerValueListener(listener, current);
    }

    @Override
    protected boolean removeAttributeListener(IProperty<Object> target, IPropertyAttributeListener<Object> listener) {
        return target.removeValueListener(listener);
    }

    @Override
    protected void setAttributeValue(IProperty<Object> p, Object attribute) {
        p.set(attribute);
    }

    public void test_getReturnsPreviouslySetValue() {
        Object newValue = this.newNonDefaultAttributeValue();
        this.target().set(newValue);
        PropertyValueTests.assertEquals((Object)newValue, (Object)this.target().get());
    }

    public void test_setThrowsIllegalStateIfReadOnly() {
        this.target().setAccess(Access.READ_ONLY);
        try {
            this.target().set(this.newNonDefaultAttributeValue());
            PropertyValueTests.fail((String)"IllegalStateException was not thrown when an attemt to set the value of a read only property was made");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void test_getReturnsValueIfReadOnly() {
        Object value = this.newNonDefaultAttributeValue();
        this.target().set(value);
        this.target().setAccess(Access.READ_ONLY);
        PropertyValueTests.assertEquals((String)"Read value doesn't match the value previously set to the property", (Object)value, (Object)this.target().get());
    }

    @Override
    public void tearDown() {
    }
}

