/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.AccessCheckingList;
import org.eclipse.platform.discovery.util.internal.property.AccessCheckingListIterator;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;
import org.jmock.core.Constraint;

public class AccessCheckingListTests
extends MockObjectTestCase {
    private Mock<List<Object>> mockListDelegate;
    private Mock<IListProperty<Object>> mockProperty;
    private AccessCheckingList<Object> target;
    private Object readWriteObj = new Object();

    public void setUp() {
        this.mockListDelegate = this.mock(List.class);
        this.mockProperty = this.mock(IListProperty.class);
        this.target = new AccessCheckingList((List)this.mockListDelegate.proxy(), (IListProperty)this.mockProperty.proxy());
    }

    public void testAddIndexReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.target.add(1, this.readWriteObj);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testAddIndexReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockListDelegate.expects(this.once()).method("add").with((Constraint)this.eq(1), (Constraint)this.same(this.readWriteObj));
        this.target.add(1, this.readWriteObj);
    }

    public void testAddReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.target.add(this.readWriteObj);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testAddReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockListDelegate.expects(this.once()).method("add").with((Constraint)this.same(this.readWriteObj)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.add(this.readWriteObj));
    }

    public void testAddAllReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            ArrayList<Object> toAdd = new ArrayList<Object>(1);
            toAdd.add(this.readWriteObj);
            this.target.addAll(toAdd);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testAddAllReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        ArrayList<Object> toAdd = new ArrayList<Object>(1);
        toAdd.add(this.readWriteObj);
        this.mockListDelegate.expects(this.once()).method("addAll").with((Constraint)this.same(toAdd)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.addAll(toAdd));
    }

    public void testAddAllIndexReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            ArrayList<Object> toAdd = new ArrayList<Object>(1);
            toAdd.add(this.readWriteObj);
            this.target.addAll(0, toAdd);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testAddAllIndexReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        ArrayList<Object> toAdd = new ArrayList<Object>(1);
        toAdd.add(this.readWriteObj);
        this.mockListDelegate.expects(this.once()).method("addAll").with((Constraint)this.eq(0), (Constraint)this.same(toAdd)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.addAll(0, toAdd));
    }

    public void testClearReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.target.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testClearReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockListDelegate.expects(this.once()).method("clear").withNoArguments();
        this.target.clear();
    }

    public void testRemoveIndexReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.target.remove(1);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveIndexReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockListDelegate.expects(this.once()).method("remove").with((Constraint)this.eq(1));
        this.target.remove(1);
    }

    public void testRemoveReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.target.remove(this.readWriteObj);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockListDelegate.expects(this.once()).method("remove").with((Constraint)this.same(this.readWriteObj)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.remove(this.readWriteObj));
    }

    public void testRemoveAllReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            ArrayList<Object> toAdd = new ArrayList<Object>(1);
            toAdd.add(this.readWriteObj);
            this.target.removeAll(toAdd);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveAllReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        ArrayList<Object> toAdd = new ArrayList<Object>(1);
        toAdd.add(this.readWriteObj);
        this.mockListDelegate.expects(this.once()).method("removeAll").with((Constraint)this.same(toAdd)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.removeAll(toAdd));
    }

    public void testRetainAllReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            ArrayList<Object> toAdd = new ArrayList<Object>(1);
            toAdd.add(this.readWriteObj);
            this.target.retainAll(toAdd);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRetainAllReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        ArrayList<Object> toAdd = new ArrayList<Object>(1);
        toAdd.add(this.readWriteObj);
        this.mockListDelegate.expects(this.once()).method("retainAll").with((Constraint)this.same(toAdd)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.retainAll(toAdd));
    }

    public void testSetReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.target.set(1, this.readWriteObj);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testSetReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockListDelegate.expects(this.once()).method("set").with((Constraint)this.eq(1), (Constraint)this.same(this.readWriteObj));
        this.target.set(1, this.readWriteObj);
    }

    public void testContains() {
        this.mockListDelegate.expects(this.once()).method("contains").with((Constraint)this.same(this.readWriteObj)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.contains(this.readWriteObj));
    }

    public void testContainsAll() {
        ArrayList<Object> contains = new ArrayList<Object>(1);
        contains.add(this.readWriteObj);
        this.mockListDelegate.expects(this.once()).method("containsAll").with((Constraint)this.same(contains)).will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.containsAll(contains));
    }

    public void testGet() {
        this.mockListDelegate.expects(this.once()).method("get").with((Constraint)this.eq(26)).will(this.returnValue(this.readWriteObj));
        AccessCheckingListTests.assertSame((Object)this.readWriteObj, (Object)this.target.get(26));
    }

    public void testIndexOf() {
        this.mockListDelegate.expects(this.once()).method("indexOf").with((Constraint)this.same(this.readWriteObj)).will(this.returnValue(26));
        AccessCheckingListTests.assertEquals((int)26, (int)this.target.indexOf(this.readWriteObj));
    }

    public void testLastIndexOf() {
        this.mockListDelegate.expects(this.once()).method("lastIndexOf").with((Constraint)this.same(this.readWriteObj)).will(this.returnValue(26));
        AccessCheckingListTests.assertEquals((int)26, (int)this.target.lastIndexOf(this.readWriteObj));
    }

    public void testIsEmpty() {
        this.mockListDelegate.expects(this.once()).method("isEmpty").withNoArguments().will(this.returnValue(true));
        AccessCheckingListTests.assertTrue((boolean)this.target.isEmpty());
    }

    public void testIterator() {
        this.mockListDelegate.expects(this.once()).method("listIterator").withNoArguments();
        AccessCheckingListTests.assertTrue((boolean)(this.target.iterator() instanceof AccessCheckingListIterator));
    }

    public void testListIterator() {
        this.mockListDelegate.expects(this.once()).method("listIterator").withNoArguments();
        AccessCheckingListTests.assertTrue((boolean)(this.target.listIterator() instanceof AccessCheckingListIterator));
    }

    public void testListIteratorIndex() {
        this.mockListDelegate.expects(this.once()).method("listIterator").with((Constraint)this.eq(0));
        AccessCheckingListTests.assertTrue((boolean)(this.target.listIterator(0) instanceof AccessCheckingListIterator));
    }

    public void testSize() {
        this.mockListDelegate.expects(this.once()).method("size").withNoArguments().will(this.returnValue(26));
        AccessCheckingListTests.assertEquals((int)26, (int)this.target.size());
    }

    public void testSubList() {
        ArrayList subList = new ArrayList(0);
        this.mockListDelegate.expects(this.once()).method("subList").with((Constraint)this.eq(1), (Constraint)this.eq(2)).will(this.returnValue(subList));
        AccessCheckingListTests.assertSame(subList, (Object)this.target.subList(1, 2));
    }

    public void testToArray() {
        Object[] arr = new Object[]{this.readWriteObj};
        this.mockListDelegate.expects(this.once()).method("toArray").withNoArguments().will(this.returnValue(arr));
        AccessCheckingListTests.assertSame((Object)arr, (Object)this.target.toArray());
    }

    public void testToArrayParameterized() {
        Object[] arr = new Object[]{};
        this.mockListDelegate.expects(this.once()).method("toArray").with((Constraint)this.same(arr)).will(this.returnValue(arr));
        AccessCheckingListTests.assertSame((Object)arr, (Object)this.target.toArray(arr));
    }
}

