/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.favorites;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.GenericResultContentProvider;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;

public class FavoritesContentProvider
extends GenericResultContentProvider {
    private final Map<Object, List<Object>> groupsMap = new HashMap<Object, List<Object>>();

    public FavoritesContentProvider(List<IGenericViewCustomization> viewCustomizations) {
        super(viewCustomizations);
    }

    @Override
    public Object[] getElements(Object inputElement) {
        return this.groupsMap.keySet().toArray();
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (this.groupsMap.containsKey(parentElement)) {
            return this.groupsMap.get(parentElement).toArray();
        }
        return super.getChildren(parentElement);
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.groupsMap.clear();
        if (newInput == null) {
            return;
        }
        HashSet newInputSet = new HashSet();
        newInputSet.addAll((Set)newInput);
        for (Object obj : newInputSet) {
            this.installItemToGroup(obj);
        }
    }

    private void installItemToGroup(Object item) {
        Object group = this.itemGroup(item);
        if (group == null) {
            return;
        }
        List<Object> groupedItems = this.groupsMap.get(group);
        if (groupedItems == null) {
            groupedItems = new ArrayList<Object>();
            this.groupsMap.put(group, groupedItems);
        }
        groupedItems.add(item);
    }

    private Object itemGroup(Object item) {
        for (IGenericViewCustomization cust : this.availableCustomizations()) {
            Object group = ((ISearchFavoritesViewCustomization)cust).itemGroup(item);
            if (group == null) continue;
            return group;
        }
        this.logger().logWarn("Item does not belong to any group");
        return null;
    }

    @Override
    public boolean hasChildren(Object element) {
        if (this.groupsMap.containsKey(element)) {
            return true;
        }
        return super.hasChildren(element);
    }

    protected ILogger logger() {
        return Logger.instance();
    }
}

