/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import javax.xml.transform.sax.TransformerHandler;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.tooltip.FormTextBuilder;
import org.eclipse.platform.discovery.util.internal.xml.IXMLUtils;
import org.jmock.core.Constraint;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class FormTextBuilderTest
extends MockObjectTestCase {
    private Mock<IXMLUtils> xmlUtils;
    private Mock<TransformerHandler> transformerHandler;
    private FormTextBuilder formTextBuilder;

    protected void setUp() throws Exception {
        this.transformerHandler = this.mock(TransformerHandler.class);
        this.transformerHandler.expects(this.once()).method("startDocument");
        this.transformerHandler.expects(this.once()).method("startElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("form"), this.emptyAttributesConstraint());
        this.xmlUtils = this.mock(IXMLUtils.class);
        this.xmlUtils.expects(this.once()).method("createTransformerHandler").will(this.returnValue(this.transformerHandler.proxy()));
        this.formTextBuilder = new FormTextBuilder(){

            protected IXMLUtils xmlUtils() {
                return (IXMLUtils)FormTextBuilderTest.this.xmlUtils.proxy();
            }
        };
    }

    public void testStartParagraphWithVSpace() {
        this.transformerHandler.expects(this.once()).method("startElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("p"), this.vspaceAttributesConstraint(true));
        this.formTextBuilder.startParagraph(true);
    }

    public void testStartParagraphWithoutVSpace() {
        this.transformerHandler.expects(this.once()).method("startElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("p"), this.vspaceAttributesConstraint(false));
        this.formTextBuilder.startParagraph(false);
    }

    public void testEndParagraph() {
        this.transformerHandler.expects(this.once()).method("endElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("p"));
        this.formTextBuilder.endParagraph();
    }

    public void testAppendBoldedText() {
        this.transformerHandler.expects(this.once()).method("startElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("b"), this.emptyAttributesConstraint());
        this.transformerHandler.expects(this.once()).method("characters").with(this.charArrConstraint("This is my test string".toCharArray()), (Constraint)this.eq(0), (Constraint)this.eq("This is my test string".length()));
        this.transformerHandler.expects(this.once()).method("endElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("b"));
        this.formTextBuilder.appendBoldedText("This is my test string");
    }

    public void testAppendText() {
        this.transformerHandler.expects(this.once()).method("characters").with(this.charArrConstraint("This is my test string".toCharArray()), (Constraint)this.eq(0), (Constraint)this.eq("This is my test string".length()));
        this.formTextBuilder.appendText("This is my test string");
    }

    public void testAppendProperty() {
        this.transformerHandler.expects(this.once()).method("startElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("p"), this.vspaceAttributesConstraint(false));
        this.transformerHandler.expects(this.once()).method("startElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("b"), this.emptyAttributesConstraint());
        this.transformerHandler.expects(this.once()).method("characters").with(this.charArrConstraint("My property".toCharArray()), (Constraint)this.eq(0), (Constraint)this.eq("My property".length()));
        this.transformerHandler.expects(this.once()).method("endElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("b"));
        this.transformerHandler.expects(this.once()).method("characters").with(this.charArrConstraint(" ".toCharArray()), (Constraint)this.eq(0), (Constraint)this.eq(1));
        this.transformerHandler.expects(this.once()).method("characters").with(this.charArrConstraint("My value".toCharArray()), (Constraint)this.eq(0), (Constraint)this.eq("My value".length()));
        this.transformerHandler.expects(this.once()).method("endElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("p"));
        this.formTextBuilder.appendProperty("My property", "My value");
    }

    public void testGetText() {
        this.transformerHandler.expects(this.once()).method("endElement").with((Constraint)this.eq(""), (Constraint)this.eq(""), (Constraint)this.eq("form"));
        this.transformerHandler.expects(this.once()).method("endDocument");
        this.formTextBuilder.getText();
    }

    private Constraint charArrConstraint(final char[] charArray) {
        return new Constraint(){

            public boolean eval(Object arg0) {
                char[] input = (char[])arg0;
                if (input.length != charArray.length) {
                    return false;
                }
                int i = 0;
                while (i < charArray.length) {
                    if (charArray[i] != input[i]) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        };
    }

    private Constraint emptyAttributesConstraint() {
        return new Constraint(){

            public boolean eval(Object arg0) {
                return ((Attributes)arg0).getLength() == 0;
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        };
    }

    private Constraint vspaceAttributesConstraint(final boolean value) {
        return new Constraint(){

            public boolean eval(Object arg0) {
                AttributesImpl attr = (AttributesImpl)arg0;
                return attr.getLength() == 1 && attr.getValue(0).equals(Boolean.toString(value)) && attr.getQName(0).equals("vspace");
            }

            public StringBuffer describeTo(StringBuffer arg0) {
                return arg0;
            }
        };
    }
}

