/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.unit.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.ui.internal.view.impl.DestinationsContentProvider;

public class DestinationsContentProviderTest
extends MockObjectTestCase {
    private DestinationsContentProvider contentProvider;
    private Mock<ISearchDestination> destination_1;
    private Mock<ISearchDestination> destination_2;
    private Mock<ISearchDestination> destination_3;
    private static final String DESTINATION_NAME_1 = "First destination";
    private static final String DESTINATION_NAME_2 = "Second destination";
    private static final String DESTINATION_NAME_3 = "Third destination";
    private Mock<IDestinationCategoryDescription> category_1;
    private Mock<IDestinationCategoryDescription> category_2;
    private static final String CATEGORY_ID_1 = "category1";
    private static final String CATEGORY_ID_2 = "category2";
    private static final String CATEGORY_NAME_1 = "First category";
    private static final String CATEGORY_NAME_2 = "Second category";

    protected void setUp() throws Exception {
        this.setupSearchDestinations();
        this.setupSearchCategories();
        this.contentProvider = new DestinationsContentProvider(){

            protected List<ISearchDestination> getSearchDestinationsForCategory(IDestinationCategoryDescription category) {
                return DestinationsContentProviderTest.this.getMockedDestinationForCategory(category);
            }
        };
    }

    private void setupSearchCategories() {
        this.category_1 = this.mock(IDestinationCategoryDescription.class);
        this.category_1.stubs().method("getId").will(this.returnValue(CATEGORY_ID_1));
        this.category_1.stubs().method("getDisplayName").will(this.returnValue(CATEGORY_NAME_1));
        this.category_2 = this.mock(IDestinationCategoryDescription.class);
        this.category_2.stubs().method("getId").will(this.returnValue(CATEGORY_ID_2));
        this.category_2.stubs().method("getDisplayName").will(this.returnValue(CATEGORY_NAME_2));
    }

    private void setupSearchDestinations() {
        this.destination_1 = this.mock(ISearchDestination.class);
        this.destination_1.stubs().method("getDisplayName").will(this.returnValue(DESTINATION_NAME_1));
        this.destination_2 = this.mock(ISearchDestination.class);
        this.destination_2.stubs().method("getDisplayName").will(this.returnValue(DESTINATION_NAME_2));
        this.destination_3 = this.mock(ISearchDestination.class);
        this.destination_3.stubs().method("getDisplayName").will(this.returnValue(DESTINATION_NAME_3));
    }

    private List<ISearchDestination> getMockedDestinationForCategory(IDestinationCategoryDescription category) {
        ArrayList<ISearchDestination> result = new ArrayList<ISearchDestination>();
        if (category.getId().equals(CATEGORY_ID_1)) {
            result.add((ISearchDestination)this.destination_1.proxy());
            result.add((ISearchDestination)this.destination_2.proxy());
        } else if (category.getId().equals(CATEGORY_ID_2)) {
            result.add((ISearchDestination)this.destination_3.proxy());
        }
        return result;
    }

    public void testGetChildrenForCategory() {
        Object o;
        ArrayList<String> destinationNames = new ArrayList<String>();
        Object[] objectArray = this.contentProvider.getChildren(this.category_1.proxy());
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            destinationNames.add(((ISearchDestination)o).getDisplayName());
            ++n2;
        }
        DestinationsContentProviderTest.assertEquals((String)"Two destinations expected for category1", (int)2, (int)destinationNames.size());
        DestinationsContentProviderTest.assertTrue((String)"Destination1 expected to be in the result", (boolean)destinationNames.contains(DESTINATION_NAME_1));
        DestinationsContentProviderTest.assertTrue((String)"Destination2 expected to be in the result", (boolean)destinationNames.contains(DESTINATION_NAME_2));
        destinationNames.clear();
        objectArray = this.contentProvider.getChildren(this.category_2.proxy());
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            o = objectArray[n2];
            destinationNames.add(((ISearchDestination)o).getDisplayName());
            ++n2;
        }
        DestinationsContentProviderTest.assertEquals((String)"Two destinations expected for category1", (int)1, (int)destinationNames.size());
        DestinationsContentProviderTest.assertTrue((String)"Destination1 expected to be in the result", (boolean)destinationNames.contains(DESTINATION_NAME_3));
    }

    public void testGetChildrenForDestination() {
        DestinationsContentProviderTest.assertTrue((String)"Empty array expected for destination children", (this.contentProvider.getChildren(this.destination_1.proxy()).length == 0 ? 1 : 0) != 0);
        DestinationsContentProviderTest.assertTrue((String)"Empty array expected for destination children", (this.contentProvider.getChildren(this.destination_2.proxy()).length == 0 ? 1 : 0) != 0);
        DestinationsContentProviderTest.assertTrue((String)"Empty array expected for destination children", (this.contentProvider.getChildren(this.destination_3.proxy()).length == 0 ? 1 : 0) != 0);
    }

    public void testGetParentForCategory() {
        DestinationsContentProviderTest.assertNull((String)"No parent expected for category", (Object)this.contentProvider.getParent(this.category_1.proxy()));
        DestinationsContentProviderTest.assertNull((String)"No parent expected for category", (Object)this.contentProvider.getParent(this.category_2.proxy()));
    }

    public void testHasChildren() {
        DestinationsContentProviderTest.assertTrue((String)"Children expected for category", (boolean)this.contentProvider.hasChildren(this.category_1.proxy()));
        DestinationsContentProviderTest.assertFalse((String)"No children expected for category", (boolean)this.contentProvider.hasChildren(this.destination_1.proxy()));
    }

    public void testGetElements() {
        List<IDestinationCategoryDescription> categories = Arrays.asList((IDestinationCategoryDescription)this.category_1.proxy(), (IDestinationCategoryDescription)this.category_2.proxy());
        Object[] elements = this.contentProvider.getElements(categories);
        DestinationsContentProviderTest.assertEquals((String)"Two elements expected", (int)2, (int)elements.length);
        ArrayList<String> elementIds = new ArrayList<String>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            elementIds.add(((IDestinationCategoryDescription)o).getId());
            ++n2;
        }
        DestinationsContentProviderTest.assertTrue((String)"Category 1 expected to be contained in the result", (boolean)elementIds.contains(CATEGORY_ID_1));
        DestinationsContentProviderTest.assertTrue((String)"Category 2 expected to be contained in the result", (boolean)elementIds.contains(CATEGORY_ID_2));
    }
}

