/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.api.ISearchFavoritesMasterController;
import org.eclipse.platform.discovery.core.internal.ContextStructuredSelection;
import org.eclipse.platform.discovery.core.internal.IContextStructuredSelection;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchFavoritesViewCustomization;
import org.eclipse.platform.discovery.ui.internal.dnd.LocalContextSelectionTransfer;
import org.eclipse.platform.discovery.ui.internal.view.SearchFavoritesView;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SWTBotToolItem;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.SwtBotUtils;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils.DndUtil;
import org.eclipse.platform.discovery.util.api.env.IDiscoveryEnvironment;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.mockito.Mockito;

public class SearchFavoritesPageObject
extends InShellPageObject {
    private static final String FAVORITES_LABEL = "This is the favorites view";
    private static final String DRAG_SOURCE_TREE = "Helper DND tree";
    private final ISearchFavoritesViewCustomization viewCustomization;
    private final IDiscoveryEnvironment env;
    private SearchFavoritesView favoritesView;
    private final SwtBotUtils botUtils;
    private TreeViewer dragHelperTreeViewer;
    private final DndUtil dndUtil;
    private final ITreeContentProvider dragHelperContentProvider;

    public SearchFavoritesPageObject(ISearchFavoritesViewCustomization viewCustomization, ITreeContentProvider dragHelperContentProvider, IDiscoveryEnvironment env) {
        this.viewCustomization = viewCustomization;
        this.dragHelperContentProvider = dragHelperContentProvider;
        this.env = env;
        this.botUtils = new SwtBotUtils();
        this.dndUtil = new DndUtil(this.display());
    }

    protected void createContent(Shell parent, FormToolkit formToolkit) {
        Composite favoritesComposite = new Composite((Composite)parent, 2048);
        favoritesComposite.setLayout((Layout)new FillLayout(512));
        Label l = new Label(favoritesComposite, 0);
        l.setText(FAVORITES_LABEL);
        final IWorkbenchPartSite wbPartSite = (IWorkbenchPartSite)Mockito.mock(IWorkbenchPartSite.class);
        final IViewSite viewSite = (IViewSite)Mockito.mock(IViewSite.class);
        IActionBars actionBars = (IActionBars)Mockito.mock(IActionBars.class);
        Mockito.stub((Object)actionBars.getToolBarManager()).toReturn(null);
        Mockito.stub((Object)viewSite.getActionBars()).toReturn((Object)actionBars);
        this.favoritesView = new SearchFavoritesView(){

            public IWorkbenchPartSite getSite() {
                return wbPartSite;
            }

            public IViewSite getViewSite() {
                return viewSite;
            }
        };
        this.favoritesView.registerViewCustomization((IGenericViewCustomization)this.viewCustomization);
        this.favoritesView.createPartControl(favoritesComposite);
        this.favoritesView.setEnvironment(this.env);
        Composite helperComposite = new Composite((Composite)parent, 2048);
        helperComposite.setLayout((Layout)new FillLayout(512));
        this.dragHelperTreeViewer = this.createDragHelperViewer(helperComposite);
        parent.layout(true, true);
    }

    private TreeViewer createDragHelperViewer(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(DRAG_SOURCE_TREE);
        final TreeViewer viewer = new TreeViewer(parent, 2048);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)this.dragHelperContentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)this.viewCustomization.getLabelProvider());
        viewer.addDragSupport(3, new Transfer[]{LocalContextSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                if (LocalContextSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                    IContextStructuredSelection selection = this.structuredSelection();
                    LocalContextSelectionTransfer.getTransfer().setSelection(selection);
                    event.data = selection;
                }
            }

            public void dragStart(DragSourceEvent event) {
                boolean bl = event.doit = !viewer.getSelection().isEmpty();
                if (event.doit) {
                    LocalContextSelectionTransfer.getTransfer().setSelection(this.structuredSelection());
                    LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.structuredSelection());
                }
            }

            private IContextStructuredSelection structuredSelection() {
                Iterator it = ((IStructuredSelection)viewer.getSelection()).iterator();
                ArrayList selectedObjects = new ArrayList();
                while (it.hasNext()) {
                    selectedObjects.add(it.next());
                }
                ISearchDestination destination = (ISearchDestination)Mockito.mock(ISearchDestination.class);
                ISearchParameters parameters = (ISearchParameters)Mockito.mock(ISearchParameters.class);
                Mockito.stub((Object)parameters.getSearchDestination()).toReturn((Object)destination);
                ISearchContext ctx = (ISearchContext)Mockito.mock(ISearchContext.class);
                Mockito.stub((Object)ctx.searchParameters()).toReturn((Object)parameters);
                return new ContextStructuredSelection(selectedObjects, ctx);
            }
        });
        viewer.setInput((Object)new Object[0]);
        viewer.refresh();
        return viewer;
    }

    public boolean canCancelRunningOperation() {
        if (!this.isOperationRunning()) {
            return false;
        }
        return this.findCancelButton().isEnabled();
    }

    public boolean isOperationRunning() {
        SWTUtils.sleep((long)1000L);
        try {
            this.findCancelButton();
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    private SWTBotToolItem findCancelButton() {
        return new SWTBotToolItem(this.botUtils.findOneChildControlOfExactType(this.shell().widget, ToolItem.class, true));
    }

    public void completeInitialization() {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SearchFavoritesPageObject.this.favoritesView.initializationCompleted();
            }
        });
    }

    public void showFavorites(final Set<Object> favorites) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SearchFavoritesPageObject.this.favoritesView.showFavorites(favorites);
            }
        });
    }

    public void registerController(final ISearchFavoritesMasterController masterController) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                SearchFavoritesPageObject.this.favoritesView.registerController(masterController);
                SearchFavoritesPageObject.this.favoritesView.initializationCompleted();
                SearchFavoritesPageObject.this.favoritesView.showFavorites(new HashSet());
                ((Shell)((SearchFavoritesPageObject)SearchFavoritesPageObject.this).shell().widget).layout(true, true);
            }
        });
    }

    public void dragToFavorites(Object draggedItem) {
        SWTBotTree dragHelperTree = new SWTBotTree(this.dragHelperTreeViewer.getTree());
        SWTBotTreeItem draggedTreeItem = dragHelperTree.getTreeItem(draggedItem.toString());
        this.dndUtil.dragAndDrop((AbstractSWTBot<? extends Widget>)draggedTreeItem, (AbstractSWTBot<? extends Widget>)this.findFavoritesTree());
    }

    private SWTBotTree findFavoritesTree() {
        return new SWTBotTree(this.botUtils.findSibling((AbstractSWTBot<? extends Control>)this.bot().label(FAVORITES_LABEL), Tree.class));
    }

    public boolean isFavoritesItemDisplayed(Object itemToSearchFor, Object parentItem) {
        return this.isChildItemDisplayed(itemToSearchFor, parentItem);
    }

    private boolean isChildItemDisplayed(Object itemToSearchFor, Object parentItem) {
        SWTBotTreeItem rootItem = this.findFavoritesRootItem(parentItem);
        try {
            this.findItem(rootItem, itemToSearchFor);
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    public boolean isFavoritesRootItemDisplayed(Object itemToSearchFor) {
        try {
            this.findFavoritesRootItem(itemToSearchFor);
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    private SWTBotTreeItem findFavoritesRootItem(Object itemToSearchFor) {
        SWTBotTreeItem treeItem = this.findItemAmong(this.findFavoritesTree().getAllItems(), itemToSearchFor);
        if (treeItem == null) {
            throw new WidgetNotFoundException(MessageFormat.format("Root favorites item {0} not found", itemToSearchFor.toString()));
        }
        return treeItem;
    }

    private SWTBotTreeItem findItem(SWTBotTreeItem parent, Object itemToSearchFor) {
        SWTBotTreeItem treeItem = this.findItemAmong(parent.getItems(), itemToSearchFor);
        if (treeItem == null) {
            throw new WidgetNotFoundException(MessageFormat.format("Child {0} of parent {1} not found", itemToSearchFor.toString(), parent.toString()));
        }
        return treeItem;
    }

    private SWTBotTreeItem findItemAmong(SWTBotTreeItem[] allItems, Object itemToSearchFor) {
        SWTBotTreeItem[] sWTBotTreeItemArray = allItems;
        int n = allItems.length;
        int n2 = 0;
        while (n2 < n) {
            SWTBotTreeItem item = sWTBotTreeItemArray[n2];
            if (this.getData((TreeItem)item.widget) == itemToSearchFor) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private Object getData(final TreeItem widget) {
        return UIThreadRunnable.syncExec((Result)new Result<Object>(){

            public Object run() {
                return widget.getData();
            }
        });
    }

    public void dragFromFavorites(Object parent, Object itemToDrag) {
        SWTBotTreeItem treeItem = this.findItemAmong(this.findFavoritesRootItem(parent).getItems(), itemToDrag);
        this.dndUtil.dragAndDrop((AbstractSWTBot<? extends Widget>)treeItem, (AbstractSWTBot<? extends Widget>)new SWTBotTree(this.dragHelperTreeViewer.getTree()));
    }

    public DragHelperTreePageObject getDragHelper() {
        return new DragHelperTreePageObject();
    }

    public class DragHelperTreePageObject {
        public void addDropSupport(final int operations, final Transfer[] transferTypes, final DropTargetListener dropTargetListener) {
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    SearchFavoritesPageObject.this.dragHelperTreeViewer.addDropSupport(operations, transferTypes, dropTargetListener);
                }
            });
        }
    }
}

