/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.internal.databinding.viewers.CheckableCheckedElementsObservableSet;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementSet;
import org.eclipse.jface.internal.databinding.viewers.ViewerObservableSetDecorator;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckableCheckedElementsProperty
extends SetProperty<ICheckable, Object> {
    private final Object elementType;

    public CheckableCheckedElementsProperty(Object elementType) {
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public Class<Object> getElementClass() {
        return Object.class;
    }

    protected Set<Object> doGetSet(ICheckable source) {
        throw new UnsupportedOperationException("Cannot query the checked elements on an ICheckable");
    }

    protected void doSetSet(ICheckable source, Set<Object> set) {
        throw new UnsupportedOperationException("Cannot batch replace the checked elements on an ICheckable.  Use updateSet(SetDiff) instead");
    }

    protected void doUpdateSet(ICheckable source, SetDiff<Object> diff) {
        ICheckable checkable = source;
        Iterator it = diff.getAdditions().iterator();
        while (it.hasNext()) {
            checkable.setChecked(it.next(), true);
        }
        it = diff.getRemovals().iterator();
        while (it.hasNext()) {
            checkable.setChecked(it.next(), false);
        }
    }

    public IObservableSet<Object> observe(ICheckable source) {
        if (source instanceof Viewer) {
            return this.observe(SWTObservables.getRealm(((Viewer)source).getControl().getDisplay()), source);
        }
        return super.observe((Object)source);
    }

    public IObservableSet<Object> observe(Realm realm, ICheckable source) {
        IElementComparer comparer = null;
        if (source instanceof StructuredViewer) {
            comparer = ((StructuredViewer)source).getComparer();
        }
        Set<Object> wrappedSet = ViewerElementSet.withComparer(comparer);
        Object observable = new CheckableCheckedElementsObservableSet(realm, wrappedSet, this.elementType, comparer, source);
        if (source instanceof Viewer) {
            observable = new ViewerObservableSetDecorator(observable, (Viewer)source);
        }
        return observable;
    }
}

