/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.databinding.viewers.IViewerUpdater;
import org.eclipse.jface.internal.databinding.viewers.ObservableCollectionContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableSetContentProvider<E>
implements IStructuredContentProvider {
    private ObservableCollectionContentProvider<E> impl;

    public ObservableSetContentProvider() {
        this(Object.class, null);
    }

    public ObservableSetContentProvider(Class<E> elementType) {
        this(elementType, null);
    }

    public ObservableSetContentProvider(IViewerUpdater viewerUpdater) {
        this.impl = new Impl(Object.class, viewerUpdater);
    }

    public ObservableSetContentProvider(Class<E> elementType, IViewerUpdater viewerUpdater) {
        this.impl = new Impl(elementType, viewerUpdater);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.impl.inputChanged(viewer, oldInput, newInput);
    }

    public Object[] getElements(Object inputElement) {
        return this.impl.getElements(inputElement);
    }

    public void dispose() {
        this.impl.dispose();
    }

    public IObservableSet<E> getKnownElements() {
        return this.impl.getKnownElements();
    }

    public IObservableSet<E> getRealizedElements() {
        return this.impl.getRealizedElements();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Impl
    extends ObservableCollectionContentProvider<E>
    implements ISetChangeListener<E> {
        protected Impl(Class<E> elementType, IViewerUpdater explicitViewerUpdater) {
            super(elementType, explicitViewerUpdater);
        }

        @Override
        protected void checkInput(Object input) {
            Assert.isTrue((boolean)(input instanceof IObservableSet), (String)"This content provider only works with input of type IObservableSet");
        }

        @Override
        protected void addCollectionChangeListener(IObservableCollection<?> collection) {
            ((IObservableSet)collection).addSetChangeListener((ISetChangeListener)this);
        }

        @Override
        protected void removeCollectionChangeListener(IObservableCollection<?> collection) {
            ((IObservableSet)collection).removeSetChangeListener((ISetChangeListener)this);
        }

        public void handleSetChange(SetChangeEvent<E> event) {
            if (this.isViewerDisposed()) {
                return;
            }
            Set removals = event.diff.getRemovals();
            Set additions = event.diff.getAdditions();
            this.knownElements.addAll((Collection)additions);
            if (this.realizedElements != null) {
                this.realizedElements.removeAll((Collection)removals);
            }
            this.viewerUpdater.remove(removals.toArray());
            this.viewerUpdater.add(additions.toArray());
            if (this.realizedElements != null) {
                this.realizedElements.addAll((Collection)additions);
            }
            this.knownElements.removeAll((Collection)removals);
        }
    }
}

