/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.e4.ui.css.core.dom.CSSStylableElement;
import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.dom.properties.providers.AbstractCSSPropertyHandlerProvider;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.exceptions.UnsupportedClassCSSPropertyException;
import org.eclipse.e4.ui.css.core.utils.StringUtils;
import org.w3c.dom.css.CSSStyleDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSPropertyHandlerLazyProviderImpl
extends AbstractCSSPropertyHandlerProvider {
    private List<String> packageNames = new ArrayList<String>();
    private Map<String, List<ICSSPropertyHandler>> propertyToHandlersMap = new HashMap<String, List<ICSSPropertyHandler>>();

    @Override
    public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(String property) throws Exception {
        Map<String, List<ICSSPropertyHandler>> propertyHandlers = this.getPropertyToHandlersMap();
        if (propertyHandlers.containsKey(property)) {
            return propertyHandlers.get(property);
        }
        ArrayList<ICSSPropertyHandler> handlers = null;
        try {
            String handlerClassName = this.getHandlerClassName(property);
            for (String packageName : this.packageNames) {
                ICSSPropertyHandler handler = this.getCSSPropertyHandler(packageName, handlerClassName);
                if (handler == null) continue;
                if (handlers == null) {
                    handlers = new ArrayList<ICSSPropertyHandler>();
                }
                handlers.add(handler);
            }
        }
        finally {
            propertyHandlers.put(property, handlers);
        }
        return handlers;
    }

    public void registerPackage(String packageName) {
        this.packageNames.add(packageName);
        this.propertyToHandlersMap = null;
    }

    protected Map<String, List<ICSSPropertyHandler>> getPropertyToHandlersMap() {
        if (this.propertyToHandlersMap == null) {
            this.propertyToHandlersMap = new HashMap<String, List<ICSSPropertyHandler>>();
        }
        return this.propertyToHandlersMap;
    }

    protected ICSSPropertyHandler getCSSPropertyHandler(String packageName, String handlerClassName) throws Exception {
        String handlerClass = String.valueOf(packageName) + "." + handlerClassName;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(handlerClass);
            Object instance = clazz.newInstance();
            if (!(instance instanceof ICSSPropertyHandler)) {
                throw new UnsupportedClassCSSPropertyException(clazz);
            }
            return (ICSSPropertyHandler)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    protected String getHandlerClassName(String property) {
        StringBuilder handlerClassName = new StringBuilder("CSSProperty");
        String[] s = StringUtils.split(property, "-");
        int i = 0;
        while (i < s.length) {
            String p = s[i];
            handlerClassName.append(p.substring(0, 1).toUpperCase());
            handlerClassName.append(p.substring(1));
            ++i;
        }
        handlerClassName.append("Handler");
        return handlerClassName.toString();
    }

    @Override
    protected CSSStyleDeclaration getDefaultCSSStyleDeclaration(CSSEngine engine, CSSStylableElement stylableElement, CSSStyleDeclaration newStyle, String pseudoE) throws Exception {
        if (stylableElement.getDefaultStyleDeclaration(pseudoE) != null) {
            return stylableElement.getDefaultStyleDeclaration(pseudoE);
        }
        if (newStyle != null) {
            StringBuffer style = null;
            int length = newStyle.getLength();
            int i = 0;
            while (i < length) {
                String propertyName = newStyle.item(i);
                String[] compositePropertiesNames = engine.getCSSCompositePropertiesNames(propertyName);
                if (compositePropertiesNames != null) {
                    int j = 0;
                    while (j < compositePropertiesNames.length) {
                        propertyName = compositePropertiesNames[j];
                        String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
                        if (s != null) {
                            if (style == null) {
                                style = new StringBuffer();
                            }
                            style.append(s);
                        }
                        ++j;
                    }
                } else {
                    String s = this.getCSSPropertyStyle(engine, stylableElement, propertyName, pseudoE);
                    if (s != null) {
                        if (style == null) {
                            style = new StringBuffer();
                        }
                        style.append(s);
                    }
                }
                ++i;
            }
            if (style != null) {
                CSSStyleDeclaration defaultStyleDeclaration = engine.parseStyleDeclaration(style.toString());
                stylableElement.setDefaultStyleDeclaration(pseudoE, defaultStyleDeclaration);
                return defaultStyleDeclaration;
            }
        }
        return stylableElement.getDefaultStyleDeclaration(pseudoE);
    }

    @Override
    public Collection<ICSSPropertyHandler> getCSSPropertyHandlers(Object element, String property) throws Exception {
        return this.getCSSPropertyHandlers(property);
    }

    @Override
    public Collection<String> getCSSProperties(Object element) {
        Map<String, List<ICSSPropertyHandler>> propertyHandlers = this.getPropertyToHandlersMap();
        return propertyHandlers.keySet();
    }
}

