/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.orion.editor.builder;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.tools.orion.editor.internal.Activator;

public class EditorOptions {
    public static final String BUILT_EDITOR_JS = "/web/built-editor.js";
    public static final String BUILT_EDITOR_CSS = "/web/built-editor.css";
    private static final String FILE_START_URL = "file://";
    private final String editorCssUrl;
    private final String editorJsUrl;
    private final String lang;
    private final Collection<String> scripts;

    public EditorOptions(String editorJsUrl, String editorCssUrl, String lang) {
        this.editorCssUrl = editorCssUrl;
        this.editorJsUrl = editorJsUrl;
        this.scripts = new ArrayList<String>();
        this.lang = lang;
    }

    public EditorOptions(String baseURL, String lang) {
        this(String.valueOf(baseURL) + BUILT_EDITOR_JS, String.valueOf(baseURL) + BUILT_EDITOR_CSS, lang);
    }

    public EditorOptions(File baseDir, String lang) {
        this(EditorOptions.toURL(baseDir), lang);
    }

    public EditorOptions(String lang) throws IOException {
        this(EditorOptions.getURL(BUILT_EDITOR_JS), EditorOptions.getURL(BUILT_EDITOR_CSS), lang);
    }

    private static String getURL(String path) throws IOException {
        if (Activator.getContext() == null) {
            throw new IOException("Cannot resolve the path=" + path + ". This constructor must be used only on OSGi context");
        }
        return FileLocator.toFileURL((URL)Activator.getContext().getBundle().getEntry(path)).toExternalForm();
    }

    private static String toURL(File file) {
        try {
            return FILE_START_URL + file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return FILE_START_URL + file.getPath();
        }
    }

    public String getEditorCssUrl() {
        return this.editorCssUrl;
    }

    public String getEditorJsUrl() {
        return this.editorJsUrl;
    }

    public void addScript(String script) {
        this.scripts.add(script);
    }

    public Collection<String> getScripts() {
        return this.scripts;
    }

    public String getLang() {
        return this.lang;
    }
}

