/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy;

import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.tools.event.spy.BindingDescriptor;
import org.eclipse.e4.tools.event.spy.CommandDescriptor;
import org.eclipse.e4.tools.event.spy.handlers.OpenSpyDialogHandler;
import org.eclipse.e4.tools.event.spy.internal.util.LoggerWrapper;
import org.eclipse.e4.tools.event.spy.internal.util.PluginUtils;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandsFactory;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;

public class Installer {
    @Inject
    private MApplication application;
    @Inject
    private LoggerWrapper logger;

    @Execute
    public void execute() {
        this.logger.info("installing ...");
        this.registerCommand(CommandDescriptor.OpenSpyDialog, BindingDescriptor.OpenSpyDialogInDialogAndWindow, OpenSpyDialogHandler.class);
        this.logger.info("installed");
    }

    private void registerCommand(CommandDescriptor commandDesc, BindingDescriptor bindingDesc, Class<?> handlerCls) {
        Object binding;
        MCommand command = this.getCommand(this.application, commandDesc);
        if (command == null) {
            command = this.createCommand(commandDesc);
            this.application.getCommands().add(command);
        }
        if ((binding = this.getBindingOrBindingTable(this.application, command, bindingDesc)) == null) {
            this.logger.warn("binding context ''{0}'' for command ''{1}'' not found", bindingDesc.getBindingContextId(), commandDesc.getName());
            return;
        }
        if (binding instanceof MKeyBinding) {
            MKeyBinding keyBinding = (MKeyBinding)binding;
            if (keyBinding.getTags().contains("type:user")) {
                this.logger.info("key binding for command ''{0}'' changed to {1}", commandDesc.getName(), keyBinding.getKeySequence());
            } else if (keyBinding.getTags().contains("deleted")) {
                this.logger.info("key binding for command ''{0}'' has been deleted. The command is disabled", commandDesc.getName());
            }
            return;
        }
        ((MBindingTable)binding).getBindings().add(this.createKeyBinding(command, bindingDesc));
        this.logger.info("key binding for command ''{0}'' is {1}", commandDesc.getName(), bindingDesc.getKeySequence());
        MHandler handler = this.getHandler(this.application, commandDesc);
        if (handler == null) {
            handler = this.createHandler(command, handlerCls);
            this.application.getHandlers().add(handler);
        }
    }

    private MCommand getCommand(MApplication application, CommandDescriptor descriptor) {
        for (MCommand command : application.getCommands()) {
            if (!descriptor.getId().equals(command.getElementId())) continue;
            return command;
        }
        return null;
    }

    private MCommand createCommand(CommandDescriptor descriptor) {
        MCommand command = MCommandsFactory.INSTANCE.createCommand();
        command.setElementId(descriptor.getId());
        command.setCommandName(descriptor.getName());
        command.setContributorURI(PluginUtils.getContributorURI());
        return command;
    }

    private MHandler getHandler(MApplication application, CommandDescriptor descriptor) {
        for (MHandler handler : application.getHandlers()) {
            if (!descriptor.getId().equals(handler.getElementId())) continue;
            return handler;
        }
        return null;
    }

    private MHandler createHandler(MCommand command, Class<?> handlerCls) {
        MHandler handler = MCommandsFactory.INSTANCE.createHandler();
        handler.setElementId(command.getElementId());
        handler.setCommand(command);
        handler.setContributionURI(PluginUtils.getContributionURI(handlerCls));
        handler.setContributorURI(PluginUtils.getContributorURI());
        return handler;
    }

    private Object getBindingOrBindingTable(MApplication application, MCommand command, BindingDescriptor descriptor) {
        MBindingTable result = null;
        for (MBindingTable bindingTable : application.getBindingTables()) {
            for (MKeyBinding keyBinding : bindingTable.getBindings()) {
                if (keyBinding.getCommand() != command) continue;
                return keyBinding;
            }
            if (!descriptor.getBindingContextId().equals(bindingTable.getBindingContext().getElementId())) continue;
            result = bindingTable;
        }
        return result;
    }

    private MKeyBinding createKeyBinding(MCommand command, BindingDescriptor descriptor) {
        MKeyBinding keyBinding = MCommandsFactory.INSTANCE.createKeyBinding();
        keyBinding.setElementId(command.getElementId());
        keyBinding.setCommand(command);
        keyBinding.setKeySequence(descriptor.getKeySequence());
        keyBinding.setContributorURI(PluginUtils.getContributorURI());
        return keyBinding;
    }
}

