/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.css.spy;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.dom.WidgetElement;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.css.sac.CSSParseException;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class CSSScratchPadWindow
extends Dialog {
    private IThemeEngine themeEngine;
    private static final int APPLY_ID = 100;
    private Text cssText;
    private Text exceptions;

    public CSSScratchPadWindow(Shell parentShell, IThemeEngine themeEngine) {
        super(parentShell);
        this.themeEngine = themeEngine;
        this.setShellStyle(2160);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("CSS Scratchpad");
    }

    protected Control createDialogArea(Composite parent) {
        Composite outer = (Composite)super.createDialogArea(parent);
        SashForm sashForm = new SashForm(outer, 512);
        this.cssText = new Text((Composite)sashForm, 2626);
        this.exceptions = new Text((Composite)sashForm, 2058);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sashForm);
        sashForm.setWeights(new int[]{80, 20});
        return outer;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, "Apply", true);
        this.createButton(parent, 0, "Close", false);
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 100: {
                this.applyCSS();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    private void applyCSS() {
        long start = System.nanoTime();
        this.exceptions.setText("");
        CSSEngine engine = WidgetElement.getEngine((Display)this.getShell().getDisplay());
        if (engine == null) {
            this.exceptions.setText("No CSS Engine available");
        }
        if (this.themeEngine != null) {
            ((ThemeEngine)this.themeEngine).resetCurrentTheme();
        }
        ExtendedDocumentCSS doc = (ExtendedDocumentCSS)engine.getDocumentCSS();
        ArrayList<StyleSheet> sheets = new ArrayList<StyleSheet>();
        StyleSheetList list = doc.getStyleSheets();
        int i = 0;
        while (i < list.getLength()) {
            sheets.add(list.item(i));
            ++i;
        }
        try {
            StringReader reader = new StringReader(this.cssText.getText());
            sheets.add(0, engine.parseStyleSheet((Reader)reader));
            doc.removeAllStyleSheets();
            for (StyleSheet sheet : sheets) {
                doc.addStyleSheet(sheet);
            }
            engine.reapply();
            long nanoDiff = System.nanoTime() - start;
            this.exceptions.setText("Total time: " + nanoDiff / 1000000L + "ms");
        }
        catch (CSSParseException e) {
            this.exceptions.setText("Error: line " + e.getLineNumber() + " col " + e.getColumnNumber() + ": " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            this.exceptions.setText("Error: " + e.getLocalizedMessage());
        }
    }
}

