function assertTrue(message, asserted) {
	if (asserted === undefined) {
		message = null;
		asserted = message;
	}
	if (!asserted) {
		throw (message ? message : 'assert failed')
	}
}

function assertFalse(message, asserted) {
	if (asserted === undefined) {
		message = null;
		asserted = message;
	}
	if (asserted) {
		throw (message ? message : 'assert failed')
	}
}

function assertEquals(message, expected, value) {
	if (value === undefined) {
		message = null;
		expected = message;
		value = expected;
	}
	if (expected === value)
		return;
	if (expected !== null && typeof expected === 'object' && typeof expected.equals === 'function' && expected.equals(value))
		return;
	var expectedMessage = '- expected: [' + expected + '] but was [' + value + '].';
	throw (message ? message : 'assert failed') + expectedMessage;
}

function assertNotEquals(message, expected, value) {
	if (value === undefined) {
		message = null;
		expected = message;
		value = expected;
	}
	if (expected === value)
		throw (message ? message : 'assert failed');
	if (expected !== null && typeof expected === 'object' && typeof expected.equals === 'function' && expected.equals(value))
		throw (message ? message : 'assert failed');
}