/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.services;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.internal.services.ResourceBundleHelper;
import org.eclipse.e4.core.internal.services.ServicesActivator;
import org.eclipse.e4.core.services.nls.IMessageFactoryService;
import org.eclipse.e4.core.services.translation.ResourceBundleProvider;
import org.osgi.service.log.LogService;

public class TranslationObjectSupplier
extends ExtendedObjectSupplier {
    private static LogService logService = ServicesActivator.getDefault().getLogService();
    private Locale locale;
    @Inject
    private ResourceBundleProvider provider;
    @Inject
    private IMessageFactoryService factoryService;
    private Map<Class<?>, Set<IRequestor>> listeners = new HashMap();

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        Class<?> descriptorsClass = this.getDesiredClass(descriptor.getDesiredType());
        if (track) {
            this.addListener(descriptorsClass, requestor);
        }
        return this.getMessageInstance(descriptorsClass);
    }

    @Inject
    public void setLocale(@Optional @Named(value="org.eclipse.e4.core.locale") String locale) {
        try {
            this.locale = locale == null ? Locale.getDefault() : ResourceBundleHelper.toLocale(locale);
        }
        catch (IllegalArgumentException e) {
            if (logService != null) {
                logService.log(1, String.valueOf(e.getMessage()) + " - Default Locale will be used instead.");
            }
            this.locale = Locale.getDefault();
        }
        catch (Exception e) {
            if (logService != null) {
                logService.log(1, "Invalid locale", (Throwable)e);
            }
            this.locale = Locale.getDefault();
        }
        this.updateMessages();
    }

    private void updateMessages() {
        for (Map.Entry<Class<?>, Set<IRequestor>> entry : this.listeners.entrySet()) {
            this.notifyRequestor((Collection<IRequestor>)entry.getValue());
        }
    }

    private Object getMessageInstance(Class<?> descriptorsClass) {
        return this.factoryService.getMessageInstance(this.locale, descriptorsClass, this.provider);
    }

    private void addListener(Class<?> descriptorsClass, IRequestor requestor) {
        Set<IRequestor> registered = this.listeners.get(descriptorsClass);
        if (registered == null) {
            registered = new HashSet<IRequestor>();
            this.listeners.put(descriptorsClass, registered);
        }
        registered.add(requestor);
    }

    private void notifyRequestor(Collection<IRequestor> requestors) {
        if (requestors != null) {
            Iterator<IRequestor> it = requestors.iterator();
            while (it.hasNext()) {
                IRequestor requestor = it.next();
                if (!requestor.isValid()) {
                    it.remove();
                    continue;
                }
                requestor.resolveArguments(false);
                requestor.execute();
            }
        }
    }

    private Class<?> getDesiredClass(Type desiredType) {
        Type rawType;
        if (desiredType instanceof Class) {
            return (Class)desiredType;
        }
        if (desiredType instanceof ParameterizedType && (rawType = ((ParameterizedType)desiredType).getRawType()) instanceof Class) {
            return (Class)rawType;
        }
        return null;
    }
}

