/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.cacheservice;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.internal.resources.semantic.cacheservice.CachedMemoryHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.ITemporaryContentHandle;
import org.eclipse.core.internal.resources.semantic.cacheservice.MemoryCache;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

class TemporaryMemoryHandle
implements ITemporaryContentHandle {
    private IPath path;
    private final boolean appendMode;
    private final ByteArrayOutputStream bos;

    public TemporaryMemoryHandle(IPath path, boolean append, ByteArrayOutputStream bos) {
        this.bos = bos;
        this.appendMode = append;
        this.path = path;
    }

    public void commit() throws CoreException {
        CachedMemoryHandle handle = MemoryCache.getInstance().getOrCreateMemoryStore(this.path.toString());
        byte[] content = this.bos.toByteArray();
        handle.setContents(content, this.appendMode);
    }

    public InputStream closeAndGetContents() {
        Util.safeClose(this.bos);
        byte[] content = this.bos.toByteArray();
        return new ByteArrayInputStream(content);
    }

    public IPath getKey() {
        return this.path;
    }

    public void flush() throws IOException {
        this.bos.flush();
    }

    public long getAppendPosition() {
        return 0L;
    }

    public void setContents(InputStream input, IProgressMonitor monitor) throws CoreException {
        Util.transferStreams(input, this.bos, monitor);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.bos.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.bos.write(b);
    }

    public void write(int b) throws IOException {
        this.bos.write(b);
    }

    public void rollback() {
    }
}

