/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.provisional.bind;

import org.eclipse.core.internal.databinding.provisional.bind.IBidiConverter;
import org.eclipse.core.internal.databinding.provisional.bind.IModelBinding;
import org.eclipse.core.internal.databinding.provisional.bind.ITargetBinding;
import org.eclipse.core.internal.databinding.provisional.bind.TwoWayBinding;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoWayConversionBinding<T2, T1>
extends TwoWayBinding<T2>
implements ITargetBinding<T1> {
    private final IModelBinding<T1> modelBinding;
    private final IBidiConverter<T1, T2> converter;

    public TwoWayConversionBinding(IModelBinding<T1> modelBinding, IBidiConverter<T1, T2> converter, boolean pullInitialValue) {
        super(pullInitialValue);
        this.modelBinding = modelBinding;
        this.converter = converter;
    }

    @Override
    public T2 getModelValue() {
        T1 modelValue = this.modelBinding.getModelValue();
        return this.converter.modelToTarget(modelValue);
    }

    @Override
    public void setModelValue(T2 valueOnTargetSide) {
        try {
            T1 valueOnModelSide = this.converter.targetToModel(valueOnTargetSide);
            this.modelBinding.setModelValue(valueOnModelSide);
            this.targetBinding.setStatus(Status.OK_STATUS);
        }
        catch (CoreException e) {
            this.targetBinding.setStatus(e.getStatus());
        }
    }

    @Override
    public void setTargetValue(T1 valueOnModelSide) {
        T2 valueOnTargetSide = this.converter.modelToTarget(valueOnModelSide);
        this.targetBinding.setTargetValue(valueOnTargetSide);
    }

    @Override
    public void setStatus(IStatus status) {
        this.targetBinding.setStatus(status);
    }

    @Override
    public void removeModelListener() {
        this.modelBinding.removeModelListener();
    }
}

