/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.internal.databinding.IdentitySet;
import org.eclipse.core.internal.databinding.Pair;

public class ObservablesManager {
    private Set<IObservable> managedObservables = new IdentitySet<IObservable>();
    private Set<IObservable> excludedObservables = new IdentitySet<IObservable>();
    private Map<DataBindingContext, Pair> contexts = new HashMap<DataBindingContext, Pair>();

    public void addObservable(IObservable observable) {
        this.managedObservables.add(observable);
    }

    public void excludeObservable(IObservable observable) {
        this.excludedObservables.add(observable);
    }

    public void addObservablesFromContext(DataBindingContext context, boolean trackTargets, boolean trackModels) {
        if (trackTargets || trackModels) {
            this.contexts.put(context, new Pair(new Boolean(trackTargets), new Boolean(trackModels)));
        }
    }

    public void runAndCollect(Runnable runnable) {
        IObservable[] collected = ObservableTracker.runAndCollect((Runnable)runnable);
        int i = 0;
        while (i < collected.length) {
            this.addObservable(collected[i]);
            ++i;
        }
    }

    public void dispose() {
        IdentitySet<Object> observables = new IdentitySet<Object>();
        observables.addAll(this.managedObservables);
        for (DataBindingContext context : this.contexts.keySet()) {
            Pair trackModelsOrTargets = this.contexts.get(context);
            boolean disposeTargets = (Boolean)trackModelsOrTargets.a;
            boolean disposeModels = (Boolean)trackModelsOrTargets.b;
            for (Binding binding : context.getBindings()) {
                if (disposeTargets) {
                    observables.add(binding.getTarget());
                }
                if (!disposeModels) continue;
                observables.add(binding.getModel());
            }
        }
        observables.removeAll(this.excludedObservables);
        for (IObservable observable : observables) {
            observable.dispose();
        }
    }
}

