/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.NativePropertyListener;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableValueProperty<T>
extends SimpleValueProperty<IObservableValue<T>, T> {
    private final Object valueTypeAsObject;
    private final Class<T> valueType;

    public ObservableValueProperty(Object valueType) {
        this.valueType = null;
        this.valueTypeAsObject = valueType;
    }

    public ObservableValueProperty(Class<T> valueType) {
        this.valueType = valueType;
        this.valueTypeAsObject = valueType;
    }

    @Override
    public Object getValueType() {
        return this.valueTypeAsObject;
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueType;
    }

    @Override
    protected T doGetValue(IObservableValue<T> source) {
        return (T)source.getValue();
    }

    @Override
    protected void doSetValue(IObservableValue<T> source, T value) {
        source.setValue(value);
    }

    @Override
    public INativePropertyListener<IObservableValue<T>> adaptListener(ISimplePropertyListener<ValueDiff<T>> listener) {
        return new NativeValueListener(this, listener);
    }

    @Override
    public IObservableValue<T> observe(Realm realm, IObservableValue<T> source) {
        return source;
    }

    public String toString() {
        String result = "IObservableValue#value";
        if (this.valueType != null) {
            result = String.valueOf(result) + " <" + this.valueType + ">";
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NativeValueListener
    extends NativePropertyListener<IObservableValue<T>, ValueDiff<T>> {
        private IValueChangeListener<T> valueChangeListener;
        private IStaleListener staleListener;

        NativeValueListener(IProperty property, ISimplePropertyListener<ValueDiff<T>> listener) {
            super(property, listener);
            this.valueChangeListener = new IValueChangeListener<T>(){

                public void handleValueChange(ValueChangeEvent<T> event) {
                    NativeValueListener.this.fireChange(event.getObservableValue(), (IDiff)event.diff);
                }
            };
            this.staleListener = new IStaleListener(){

                public void handleStale(StaleEvent event) {
                    NativeValueListener.this.fireStale(event.getObservable());
                }
            };
        }

        @Override
        protected void doAddTo(IObservableValue<T> source) {
            IObservableValue observable = source;
            observable.addValueChangeListener(this.valueChangeListener);
            observable.addStaleListener(this.staleListener);
        }

        @Override
        protected void doRemoveFrom(IObservableValue<T> source) {
            IObservableValue observable = source;
            observable.removeValueChangeListener(this.valueChangeListener);
            observable.removeStaleListener(this.staleListener);
        }
    }
}

