/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.property;

import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NativePropertyListener<S, D extends IDiff>
implements INativePropertyListener<S> {
    private final IProperty property;
    private final ISimplePropertyListener<D> listener;

    public NativePropertyListener(IProperty property, ISimplePropertyListener<D> listener) {
        this.property = property;
        this.listener = listener;
    }

    @Override
    public final void addTo(S source) {
        if (source != null) {
            this.doAddTo(source);
        }
    }

    protected abstract void doAddTo(S var1);

    @Override
    public final void removeFrom(S source) {
        if (source != null) {
            this.doRemoveFrom(source);
        }
    }

    protected abstract void doRemoveFrom(S var1);

    protected void fireChange(Object source, D diff) {
        this.listener.handleEvent(new SimplePropertyEvent<D>(SimplePropertyEvent.CHANGE, source, this.property, diff));
    }

    protected void fireStale(Object source) {
        this.listener.handleEvent(new SimplePropertyEvent<Object>(SimplePropertyEvent.STALE, source, this.property, null));
    }
}

