/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.ValueDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractObservableValue<T>
extends AbstractObservable
implements IObservableValue<T> {
    protected ListenerList<IValueChangeListener<T>> valueListenerList = null;

    public AbstractObservableValue() {
        this(Realm.getDefault());
    }

    public AbstractObservableValue(Realm realm) {
        super(realm);
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<T> listener) {
        this.addListener(this.getValueChangeListenerList(), listener);
    }

    @Override
    public synchronized void removeValueChangeListener(IValueChangeListener<T> listener) {
        if (this.valueListenerList != null) {
            this.removeListener(this.valueListenerList, listener);
        }
    }

    private ListenerList<IValueChangeListener<T>> getValueChangeListenerList() {
        if (this.valueListenerList == null) {
            this.valueListenerList = new ListenerList();
        }
        return this.valueListenerList;
    }

    @Override
    protected boolean hasListeners() {
        return this.valueListenerList != null && this.valueListenerList.hasListeners() || super.hasListeners();
    }

    @Override
    public final void setValue(T value) {
        this.checkRealm();
        this.doSetValue(value);
    }

    protected void doSetValue(T value) {
        throw new UnsupportedOperationException();
    }

    protected void fireValueChange(ValueDiff<T> diff) {
        super.fireChange();
        if (this.valueListenerList != null) {
            this.valueListenerList.fireEvent(new ValueChangeEvent<T>(this, diff));
        }
    }

    @Override
    public final T getValue() {
        this.getterCalled();
        return this.doGetValue();
    }

    protected abstract T doGetValue();

    @Override
    public boolean isStale() {
        this.getterCalled();
        return false;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireValueChange() instead");
    }

    @Override
    public Class<T> getValueClass() {
        Object valueType = this.getValueType();
        if (valueType instanceof Class) {
            return (Class)valueType;
        }
        return null;
    }

    @Override
    public synchronized void dispose() {
        this.valueListenerList = null;
        super.dispose();
    }
}

