/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable;

import org.eclipse.core.databinding.observable.IObservablesListener;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.ObservableEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeManager<EV extends ObservableEvent<EV, L>, L extends IObservablesListener<L>> {
    ListenerList<L> listenerList = null;

    public void addListener(L listener) {
        this.listenerList.add(listener);
    }

    public void removeListener(L listener) {
        if (this.listenerList != null) {
            this.listenerList.remove(listener);
        }
    }

    public boolean hasListeners() {
        return this.listenerList.size() > 0;
    }

    public void fireEvent(ObservableEvent<EV, L> event) {
        for (IObservablesListener listener : this.listenerList.getListeners()) {
            event.dispatch(listener);
        }
    }

    public void dispose() {
        this.listenerList = null;
    }

    protected Object clone() throws CloneNotSupportedException {
        ChangeManager duplicate = (ChangeManager)super.clone();
        duplicate.listenerList = null;
        return duplicate;
    }
}

