/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.map.MapDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableMap<K, V>
extends AbstractObservable
implements IObservableMap<K, V> {
    protected Map<K, V> wrappedMap;
    private boolean stale = false;
    private ListenerList<IMapChangeListener<K, V>> mapChangeListenerList = null;

    public ObservableMap(Map<K, V> wrappedMap) {
        this(Realm.getDefault(), wrappedMap);
    }

    public ObservableMap(Realm realm, Map<K, V> wrappedMap) {
        super(realm);
        this.wrappedMap = wrappedMap;
    }

    @Override
    public synchronized void addMapChangeListener(IMapChangeListener<K, V> listener) {
        this.addListener(this.getMapChangeListenerList(), listener);
    }

    @Override
    public synchronized void removeMapChangeListener(IMapChangeListener<K, V> listener) {
        if (this.mapChangeListenerList != null) {
            this.removeListener(this.mapChangeListenerList, listener);
        }
    }

    private ListenerList<IMapChangeListener<K, V>> getMapChangeListenerList() {
        if (this.mapChangeListenerList == null) {
            this.mapChangeListenerList = new ListenerList();
        }
        return this.mapChangeListenerList;
    }

    @Override
    protected boolean hasListeners() {
        return this.mapChangeListenerList != null && this.mapChangeListenerList.hasListeners() || super.hasListeners();
    }

    @Override
    public Object getKeyType() {
        return null;
    }

    @Override
    public Object getValueType() {
        return null;
    }

    protected void getterCalled() {
        ObservableTracker.getterCalled(this);
    }

    protected <K2 extends K, V2 extends V> void fireMapChange(MapDiff<K2, V2> diff) {
        this.checkRealm();
        super.fireChange();
        if (this.mapChangeListenerList != null) {
            this.mapChangeListenerList.fireEvent(new MapChangeEvent<K2, V2>(this, diff));
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.getterCalled();
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.getterCalled();
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.getterCalled();
        return this.wrappedMap.entrySet();
    }

    @Override
    public V get(Object key) {
        this.getterCalled();
        return this.wrappedMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.wrappedMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        this.getterCalled();
        return this.wrappedMap.keySet();
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.wrappedMap.size();
    }

    @Override
    public Collection<V> values() {
        this.getterCalled();
        return this.wrappedMap.values();
    }

    @Override
    public boolean isStale() {
        this.checkRealm();
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.checkRealm();
        boolean wasStale = this.stale;
        this.stale = stale;
        if (!wasStale && stale) {
            this.fireStale();
        }
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        this.getterCalled();
        return o == this || this.wrappedMap.equals(o);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.wrappedMap.hashCode();
    }

    @Override
    public synchronized void dispose() {
        this.mapChangeListenerList = null;
        super.dispose();
    }
}

