/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.list.SimpleListProperty;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.BeanPropertyListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanListProperty<S, E>
extends SimpleListProperty<S, E> {
    private final PropertyDescriptor propertyDescriptor;
    private final Class<E> elementType;

    public BeanListProperty(PropertyDescriptor propertyDescriptor, Class<E> elementType) {
        if (elementType == null) {
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", "elementType cannot be null"));
            elementType = propertyDescriptor.getPropertyType().isArray() ? propertyDescriptor.getPropertyType().getComponentType() : Object.class;
        }
        BeanPropertyHelper.checkCollectionPropertyElementType(propertyDescriptor, elementType);
        this.propertyDescriptor = propertyDescriptor;
        this.elementType = elementType;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public Class<E> getElementClass() {
        return this.elementType;
    }

    protected List<E> doGetList(S source) {
        return this.asList(BeanPropertyHelper.readProperty(source, this.propertyDescriptor));
    }

    private List<?> asList(Object propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            return Arrays.asList((Object[])propertyValue);
        }
        return (List)propertyValue;
    }

    protected void doSetList(S source, List<E> list, ListDiff<E> diff) {
        this.doSetList(source, list);
    }

    protected void doSetList(S source, List<E> list) {
        BeanPropertyHelper.writeProperty(source, this.propertyDescriptor, this.convertListToBeanPropertyType(list));
    }

    private Object convertListToBeanPropertyType(List<E> list) {
        Object[] propertyValue = list;
        if (this.propertyDescriptor.getPropertyType().isArray()) {
            Class<?> componentType = this.propertyDescriptor.getPropertyType().getComponentType();
            Object[] array = (Object[])Array.newInstance(componentType, list.size());
            list.toArray(array);
            propertyValue = array;
        }
        return propertyValue;
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<ListDiff<E>> listener) {
        return new BeanPropertyListener<S, ListDiff<E>>((IProperty)this, this.propertyDescriptor, listener){

            @Override
            protected ListDiff<E> computeDiff(Object oldValue, Object newValue) {
                return Diffs.computeAndCastListDiff((List)BeanListProperty.this.asList(oldValue), (List)BeanListProperty.this.asList(newValue), (Class)BeanListProperty.this.elementType);
            }
        };
    }

    public String toString() {
        String s = String.valueOf(BeanPropertyHelper.propertyName(this.propertyDescriptor)) + "[]";
        if (this.elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(this.elementType) + ">";
        }
        return s;
    }
}

