/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.property.ExpectedListChangedEventConstraint;
import org.eclipse.platform.discovery.util.internal.property.ExpectedSingleListChangedEventConstraint;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;
import org.eclipse.platform.discovery.util.internal.property.IListPropertyListener;
import org.eclipse.platform.discovery.util.internal.property.ListProperty;
import org.eclipse.platform.discovery.util.internal.property.PropertyListChangedEvent;
import org.jmock.core.Constraint;

public class ListPropertyListTests
extends MockObjectTestCase {
    private ListProperty<Object> target;
    private List<Object> objectsInCollection;
    private Mock<IListPropertyListener<Object>> mockListener;

    public void setUp() {
        this.target = new ListProperty();
        this.objectsInCollection = new ArrayList<Object>();
        int i = 0;
        while (i < 3) {
            this.objectsInCollection.add(new Object());
            ++i;
        }
        ((List)this.target.get()).addAll(this.objectsInCollection);
        this.mockListener = this.mock(IListPropertyListener.class);
    }

    public void test_resigerListenerDoesntDeliverCurrent() {
        this.target.registerCollectionChangedListener((IListPropertyListener)this.mockListener.proxy(), false);
    }

    public void test_registerListenerDeliversCurrent() {
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedListChangedEventConstraint((IListProperty<Object>)this.target, PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, this.objectsInCollection));
        this.target.registerCollectionChangedListener((IListPropertyListener)this.mockListener.proxy(), true);
    }

    public void testRegisterListenerHasNoEffectIfAlreadyRegistered() {
        Object addedObject = new Object();
        ListPropertyListTests.assertTrue((boolean)this.target.registerCollectionChangedListener((IListPropertyListener)this.mockListener.proxy(), false));
        ListPropertyListTests.assertFalse((boolean)this.target.registerCollectionChangedListener((IListPropertyListener)this.mockListener.proxy(), true));
        this.mockListener.expects(this.once()).method("listChanged").with((Constraint)new ExpectedSingleListChangedEventConstraint((IListProperty<Object>)this.target, PropertyListChangedEvent.ChangeKind.ELEMENT_ADDED, addedObject));
        ((List)this.target.get()).add(addedObject);
    }
}

