/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ISubdestinationsActivationConfig;
import org.eclipse.platform.discovery.runtime.internal.IXPParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.ISearchProvidersExtensionParser;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;

public class SearchProviderConfiguration
implements ISearchProviderConfiguration {
    private final ISearchProviderActivationConfig searchProviderActivationConfig;
    private final ISubdestinationsActivationConfig subdestinationsActivationConfig;
    private final ILogger logger = Logger.instance();
    private IXPParsersFactory parsersFactory;

    public SearchProviderConfiguration(IXPParsersFactory parsersFactory, ISearchProviderActivationConfig searchProviderActivationConfig, ISubdestinationsActivationConfig subdestinationsActivationConfig) {
        this.parsersFactory = parsersFactory;
        this.searchProviderActivationConfig = searchProviderActivationConfig;
        this.subdestinationsActivationConfig = subdestinationsActivationConfig;
    }

    protected ISearchProvidersExtensionParser searchProvidersExtensionParser() {
        return this.parsersFactory.createSearchProviderParser();
    }

    @Override
    public List<ISearchProviderDescription> getAvailableSearchProviderDescriptions(IObjectTypeDescription searchObjectType) {
        List allProviders = this.searchProvidersExtensionParser().readContributions();
        ArrayList<ISearchProviderDescription> result = new ArrayList<ISearchProviderDescription>();
        for (ISearchProviderDescription provider : allProviders) {
            if (!provider.getObjectType().getId().equals(searchObjectType.getId())) continue;
            result.add(provider);
        }
        return result;
    }

    @Override
    public List<IObjectTypeDescription> getObjectTypes() {
        return this.parsersFactory.createObjectTypeParser().readContributions();
    }

    @Override
    public void activateSubdestination(IObjectTypeDescription searchObjectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription searchProviderDescription, ISearchSubdestination subDestination, boolean activate) {
        this.subdestinationsActivationConfig.activateSubdestination(searchObjectType, destinationCategory, searchProviderDescription, subDestination, activate);
    }

    @Override
    public ISearchProviderDescription getActiveSearchProvider(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory) throws ProviderNotFoundException {
        return destinationCategory != null ? this.searchProviderActivationConfig.getActiveSearchProviderDescription(objectType, destinationCategory) : this.searchProviderActivationConfig.getActiveSearchProviderDescription(objectType);
    }

    @Override
    public List<IDestinationCategoryDescription> getAvailableDestinationCategoriesForObjectType(IObjectTypeDescription objectType) {
        ArrayList<IDestinationCategoryDescription> result = new ArrayList<IDestinationCategoryDescription>();
        for (IDestinationCategoryDescription category : this.getDestinationCategories()) {
            try {
                this.getActiveSearchProvider(objectType, category);
                result.add(category);
            }
            catch (ProviderNotFoundException providerNotFoundException) {}
        }
        return result;
    }

    @Override
    public List<ISearchSubdestination> getAvailableSearchSubdestinations(IObjectTypeDescription objectType, IDestinationCategoryDescription destinationCategory, ISearchProviderDescription provider) {
        return this.subdestinationsActivationConfig.getAvailableSearchSubdestinations(objectType, destinationCategory, provider);
    }

    @Override
    public List<IDestinationCategoryDescription> getDestinationCategories() {
        return this.parsersFactory.createDestinationsCategoryParser().readContributions();
    }

    @Override
    public List<IDestinationsProviderDescription> getDestinationProvidersForCategory(IDestinationCategoryDescription category) {
        ArrayList<IDestinationsProviderDescription> result = new ArrayList<IDestinationsProviderDescription>();
        for (IDestinationsProviderDescription destProvider : this.getAvailableDestinationProviders()) {
            if (!category.getDestinationProviderIds().contains(destProvider.getId())) continue;
            result.add(destProvider);
        }
        return result;
    }

    @Override
    public List<ISearchDestination> getSearchDestinations(IDestinationCategoryDescription category, IDestinationsProvider destinationsProvider) {
        ArrayList<ISearchDestination> result = new ArrayList<ISearchDestination>();
        Class<ISearchDestination> expectedDestinationClass = category.getDestinationsClass();
        for (ISearchDestination dest : destinationsProvider.getSearchDestinations()) {
            if (expectedDestinationClass.isAssignableFrom(dest.getClass())) {
                result.add(dest);
                continue;
            }
            this.logger.logWarn("Provider " + destinationsProvider.getClass().getName() + " did not provide destination of class " + category.getDestinationsClass().getName());
        }
        return result;
    }

    @Override
    public List<IDestinationCategoryDescription> getDestinationCategoriesForDestination(ISearchDestination destination) throws DestinationCategoryNotFoundException {
        ArrayList<IDestinationCategoryDescription> result = new ArrayList<IDestinationCategoryDescription>();
        ArrayList<String> destinationProvidersIds = new ArrayList<String>();
        for (IDestinationsProviderDescription providerDescription : this.getAvailableDestinationProviders()) {
            if (!providerDescription.createProvider().getSearchDestinations().contains(destination)) continue;
            destinationProvidersIds.add(providerDescription.getId());
        }
        for (IDestinationCategoryDescription cat : this.getDestinationCategories()) {
            if (Collections.disjoint(destinationProvidersIds, cat.getDestinationProviderIds())) continue;
            result.add(cat);
        }
        if (result.isEmpty()) {
            throw new DestinationCategoryNotFoundException("Destination category for destination id " + destination.getDisplayName() + " was not found");
        }
        return result;
    }

    @Override
    public boolean isSubdestinationActive(ISearchSubdestination subdestination, IObjectTypeDescription objectType, IDestinationCategoryDescription destCategory, ISearchProviderDescription searchProvider) {
        return this.subdestinationsActivationConfig.isSubdestinationActive(subdestination, objectType, destCategory, searchProvider);
    }

    @Override
    public List<IDestinationsProviderDescription> getAvailableDestinationProviders() {
        return this.parsersFactory.createDestinationsProviderParser().readContributions();
    }
}

