/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.destprefs.internal.prefpage.ui;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.platform.discovery.destprefs.internal.i18n.DestPrefsMessages;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationProviderPair;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.CategoryDestinationsContentProvider;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationConfiguratorSelection;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationConfiguratorsPresenter;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.DestinationsLabelProvider;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsPresenter;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.IDestinationConfiguratorsView;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.nodes.CategoryNode;
import org.eclipse.platform.discovery.destprefs.internal.prefpage.ui.nodes.DestinationNode;
import org.eclipse.platform.discovery.destprefs.internal.xpparser.SearchDestinationsConfiguratorXPParser;
import org.eclipse.platform.discovery.runtime.internal.SearchProviderConfigurationFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DestinationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IDestinationConfiguratorsView {
    private final IDestinationConfiguratorsPresenter presenter;
    private TreeViewer destinationsTreeViewer;
    private Button addDestinationButton;
    private Button removeDestinationButton;
    private Button deleteDestinationButton;
    private Button testDestinationButton;
    private StatusLineManager statusLineManager;

    public DestinationsPreferencePage(IDestinationConfiguratorsPresenter presenter) {
        this.presenter = presenter;
    }

    public DestinationsPreferencePage() {
        this(new DestinationConfiguratorsPresenter(new SearchDestinationsConfiguratorXPParser(Platform.getExtensionRegistry()), new SearchProviderConfigurationFactory().getSearchProviderConfiguration(Platform.getExtensionRegistry())));
    }

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        containerComposite.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.defaultsFor((Control)containerComposite).align(4, 4).grab(true, true).applyTo((Control)containerComposite);
        Composite destinationsComposite = new Composite(containerComposite, 0);
        destinationsComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.defaultsFor((Control)destinationsComposite).align(4, 4).grab(true, true).applyTo((Control)destinationsComposite);
        Composite treeViewerComposite = new Composite(destinationsComposite, 0);
        treeViewerComposite.setLayout((Layout)new FillLayout(512));
        GridDataFactory.defaultsFor((Control)treeViewerComposite).align(4, 4).grab(true, true).applyTo((Control)treeViewerComposite);
        this.destinationsTreeViewer = this.createDestinationsTreeViewer(treeViewerComposite);
        Composite buttonsComposite = new Composite(destinationsComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.defaultsFor((Control)buttonsComposite).align(0x1000008, 4).grab(false, true).applyTo((Control)buttonsComposite);
        this.addDestinationButton = this.createAddDestinationButton(buttonsComposite);
        this.removeDestinationButton = this.createEditDestinationButton(buttonsComposite);
        this.deleteDestinationButton = this.createDeleteDestinationButton(buttonsComposite);
        this.testDestinationButton = this.createTestDestinationButton(buttonsComposite);
        Composite statusLineComposite = new Composite(containerComposite, 0);
        statusLineComposite.setLayout((Layout)new FillLayout(256));
        GridDataFactory.defaultsFor((Control)statusLineComposite).align(4, 4).grab(true, false).span(2, 1).applyTo((Control)statusLineComposite);
        this.statusLineManager = new StatusLineManager();
        this.statusLineManager.createControl(statusLineComposite, 0);
        this.presenter.setView(this);
        return destinationsComposite;
    }

    private TreeViewer createDestinationsTreeViewer(Composite parent) {
        TreeViewer viewer = new TreeViewer(parent, 2052);
        viewer.addSelectionChangedListener(this.destinationsSelectionChangeListener());
        viewer.setLabelProvider((IBaseLabelProvider)new DestinationsLabelProvider());
        viewer.setContentProvider((IContentProvider)new CategoryDestinationsContentProvider());
        return viewer;
    }

    private ISelectionChangedListener destinationsSelectionChangeListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    DestinationsPreferencePage.this.presenter.selectionChanged(new DestinationConfiguratorSelection(null, null));
                    return;
                }
                Object selectedElement = ((StructuredSelection)event.getSelection()).getFirstElement();
                if (selectedElement instanceof CategoryNode) {
                    DestinationsPreferencePage.this.presenter.selectionChanged(new DestinationConfiguratorSelection(((CategoryNode)selectedElement).getDestinationProviderId(), null));
                    return;
                }
                if (selectedElement instanceof DestinationNode) {
                    DestinationNode destNode = (DestinationNode)selectedElement;
                    DestinationsPreferencePage.this.presenter.selectionChanged(new DestinationConfiguratorSelection(destNode.getParentNode().getDestinationProviderId(), destNode.getDestination()));
                    return;
                }
                throw new IllegalArgumentException("Unsupported element: " + selectedElement);
            }
        };
    }

    private Button createAddDestinationButton(Composite parent) {
        Button button = this.createDisabledButton(parent, DestPrefsMessages.DestinationsPrefPage_AddButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationsPreferencePage.this.presenter.addDestination();
            }
        });
        return button;
    }

    private Button createEditDestinationButton(Composite parent) {
        Button button = this.createDisabledButton(parent, DestPrefsMessages.DestinationsPrefPage_EditButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationsPreferencePage.this.presenter.editDestination();
            }
        });
        return button;
    }

    private Button createDeleteDestinationButton(Composite parent) {
        Button button = this.createDisabledButton(parent, DestPrefsMessages.DestinationsPrefPage_DeleteButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationsPreferencePage.this.presenter.removeDestination();
            }
        });
        return button;
    }

    private Button createTestDestinationButton(Composite parent) {
        Button button = this.createDisabledButton(parent, DestPrefsMessages.DestinationsPrefPage_TestButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DestinationsPreferencePage.this.presenter.testDestination();
            }
        });
        return button;
    }

    private Button createDisabledButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        GridDataFactory.defaultsFor((Control)button).applyTo((Control)button);
        button.setEnabled(false);
        return button;
    }

    @Override
    public void setInput(Collection<CategoryDestinationProviderPair> input) {
        Object[] expandedElements = this.destinationsTreeViewer.getExpandedElements();
        ISelection selection = this.destinationsTreeViewer.getSelection();
        this.destinationsTreeViewer.setInput(input);
        this.destinationsTreeViewer.setExpandedElements(expandedElements);
        this.destinationsTreeViewer.setSelection(selection);
    }

    @Override
    public void setStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                this.statusLineManager.setErrorMessage(this.imageForStatus(status), status.getMessage());
                this.statusLineManager.setMessage(null, null);
                break;
            }
            case 0: {
                this.statusLineManager.setErrorMessage(null, null);
                this.statusLineManager.setMessage(null, null);
                break;
            }
            default: {
                this.statusLineManager.setMessage(this.imageForStatus(status), status.getMessage());
                this.statusLineManager.setErrorMessage(null, null);
            }
        }
    }

    @Override
    public void setAddEnabled(boolean enabled) {
        this.addDestinationButton.setEnabled(enabled);
    }

    @Override
    public void setEditEnabled(boolean enabled) {
        this.removeDestinationButton.setEnabled(enabled);
    }

    @Override
    public void setRemoveEnabled(boolean enabled) {
        this.deleteDestinationButton.setEnabled(enabled);
    }

    @Override
    public void setTestEnabled(boolean enabled) {
        this.testDestinationButton.setEnabled(enabled);
    }

    private Image imageForStatus(IStatus status) {
        switch (status.getSeverity()) {
            case 4: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
            }
            case 2: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
            }
            case 1: {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }
}

