/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal;

import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.platform.discovery.compatibility.internal.contributors.ContributionFailedException;
import org.eclipse.platform.discovery.compatibility.internal.contributors.IDynamicRegistryContributor;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.DynamicObjectTypeContributor;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.DynamicSearchProviderContributor;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageParser;
import org.eclipse.platform.discovery.compatibility.internal.readers.impl.SearchPageParser;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.ui.IStartup;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DiscoveryCompatibilityPlugin
extends Plugin
implements IStartup {
    public static final String SYMBOLIC_NAME = "org.eclipse.platform.discovery.compatibility";
    private static DiscoveryCompatibilityPlugin plugin;
    private final ILogger logger = new Logger();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        SearchPageParser parser = new SearchPageParser(this.getRegistry());
        this.contributeDynamicObjectTypes(parser);
        this.contributeDynamicSearchProviders(parser);
    }

    private void contributeDynamicObjectTypes(ISearchPageParser parser) {
        this.makeDynamicContribution(new DynamicObjectTypeContributor(parser));
    }

    private void contributeDynamicSearchProviders(ISearchPageParser parser) {
        this.makeDynamicContribution(new DynamicSearchProviderContributor(parser));
    }

    private void makeDynamicContribution(IDynamicRegistryContributor dynamicRegistryContributor) {
        try {
            dynamicRegistryContributor.contribute(this.getRegistry(), this.getContributor(), this.getUserToken());
        }
        catch (ContributionFailedException ex) {
            this.logger().logError(ex.getMessage());
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static DiscoveryCompatibilityPlugin getDefault() {
        return plugin;
    }

    public ILogger logger() {
        return this.logger;
    }

    private IContributor getContributor() {
        return ContributorFactoryOSGi.createContributor((Bundle)this.getBundle());
    }

    private IExtensionRegistry getRegistry() {
        return Platform.getExtensionRegistry();
    }

    private Object getUserToken() {
        return ((ExtensionRegistry)this.getRegistry()).getTemporaryUserToken();
    }

    public void earlyStartup() {
    }
}

