/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.ComputedObservableMap;
import org.eclipse.core.databinding.observable.map.MapDiff;
import org.eclipse.core.databinding.observable.set.IObservableSet;

public class SomeMathFunction
extends ComputedObservableMap {
    public static final int OP_IDENTITY = 0;
    public static final int OP_MULTIPLY = 1;
    public static final int OP_ROUND = 2;
    private int op = 2;

    public SomeMathFunction(IObservableSet domain) {
        super(domain);
        this.init();
    }

    public void setOperation(final int operation) {
        final int oldOp = this.op;
        this.op = operation;
        this.fireMapChange(new MapDiff(){

            public Set getAddedKeys() {
                return Collections.EMPTY_SET;
            }

            public Set getChangedKeys() {
                return SomeMathFunction.this.keySet();
            }

            public Object getNewValue(Object key) {
                return SomeMathFunction.this.doComputeResult(key, operation);
            }

            public Object getOldValue(Object key) {
                return SomeMathFunction.this.doComputeResult(key, oldOp);
            }

            public Set getRemovedKeys() {
                return Collections.EMPTY_SET;
            }
        });
    }

    private Object doComputeResult(Object element, int op) {
        switch (op) {
            case 0: {
                return element;
            }
            case 1: {
                return new Double((Double)element * 2.0);
            }
            case 2: {
                return new Double(Math.floor((Double)element));
            }
        }
        return element;
    }

    protected Object doGet(Object key) {
        return this.doComputeResult(key, this.op);
    }

    protected Object doPut(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    protected void hookListener(Object addedKey) {
    }

    protected void unhookListener(Object removedKey) {
    }
}

