/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.model;

import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;

public class AggregateObservableValue
extends AbstractObservableValue {
    private IObservableValue[] observableValues;
    private String delimiter;
    private boolean updating = false;
    private String currentValue;
    private IValueChangeListener listener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            if (!AggregateObservableValue.this.updating) {
                AggregateObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)AggregateObservableValue.this.currentValue, (Object)AggregateObservableValue.this.doGetValue()));
            }
        }
    };

    public AggregateObservableValue(IObservableValue[] observableValues, String delimiter) {
        this.observableValues = observableValues;
        this.delimiter = delimiter;
        int i = 0;
        while (i < observableValues.length) {
            observableValues[i].addValueChangeListener(this.listener);
            ++i;
        }
        this.doGetValue();
    }

    public void doSetValue(Object value) {
        Object oldValue = this.doGetValue();
        StringTokenizer tokenizer = new StringTokenizer((String)value, this.delimiter);
        try {
            this.updating = true;
            int i = 0;
            while (i < this.observableValues.length) {
                if (tokenizer.hasMoreElements()) {
                    this.observableValues[i].setValue(tokenizer.nextElement());
                } else {
                    this.observableValues[i].setValue(null);
                }
                ++i;
            }
        }
        finally {
            this.updating = false;
        }
        this.doGetValue();
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
    }

    public Object doGetValue() {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < this.observableValues.length) {
            if (i > 0 & i < this.observableValues.length) {
                result.append(this.delimiter);
            }
            result.append(this.observableValues[i].getValue());
            ++i;
        }
        this.currentValue = result.toString();
        return this.currentValue;
    }

    public Object getValueType() {
        return String.class;
    }

    public synchronized void dispose() {
        int i = 0;
        while (i < this.observableValues.length) {
            this.observableValues[i].removeValueChangeListener(this.listener);
            ++i;
        }
        super.dispose();
    }
}

