/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.virtual;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.component.AbstractComponentEditor;
import org.eclipse.e4.tools.emf.ui.internal.common.ComponentLabelProvider;
import org.eclipse.e4.tools.emf.ui.internal.common.VirtualEntry;
import org.eclipse.e4.tools.emf.ui.internal.common.uistructure.ViewerElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicPackageImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuPackageImpl;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class VMenuEditor
extends AbstractComponentEditor {
    private Composite composite;
    private EMFDataBindingContext context;
    private StructuredViewer viewer;
    private List<Action> actions = new ArrayList<Action>();
    private EStructuralFeature feature;
    @Inject
    IEclipseContext eclipseContext;
    public static final String VIEW_MENU_TAG = "ViewMenu";

    protected VMenuEditor(EStructuralFeature feature) {
        this.feature = feature;
    }

    @PostConstruct
    void init() {
        this.actions.add(new Action(this.Messages.VMenuEditor_AddMenuContribution, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.MENU);
            }
        });
        this.actions.add(new Action(this.Messages.VMenuEditor_AddPopupMenuContribution, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.POPUP_MENU);
            }
        });
        this.actions.add(new Action(this.Messages.MenuEditor_Label_ViewMenu, this.createImageDescriptor("IMG_org.eclipse.e4.tools.emf.ui.modelelements.Menu")){

            public void run() {
                VMenuEditor.this.handleAddViewMenu();
            }
        });
    }

    @Override
    public Image getImage(Object element, Display display) {
        return null;
    }

    @Override
    public String getLabel(Object element) {
        return this.Messages.VMenuEditor_TreeLabel;
    }

    @Override
    public String getDetailLabel(Object element) {
        return null;
    }

    @Override
    public String getDescription(Object element) {
        return this.Messages.VMenuEditor_TreeLabelDescription;
    }

    @Override
    public Composite doGetEditor(Composite parent, Object object) {
        if (this.composite == null) {
            this.context = new EMFDataBindingContext();
            this.composite = this.createForm(parent, this.context, this.getMaster());
        }
        VirtualEntry o = (VirtualEntry)object;
        this.viewer.setInput((Object)o.getList());
        this.getMaster().setValue(o.getOriginalParent());
        return this.composite;
    }

    private Composite createForm(Composite parent, EMFDataBindingContext context, WritableValue master) {
        CTabFolder folder = new CTabFolder(parent, 1024);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(this.Messages.ModelTooling_Common_TabDefault);
        parent = this.createScrollableContainer((Composite)folder);
        item.setControl((Control)parent.getParent());
        final ViewerElement tableElement = ViewerElement.create(this.eclipseContext, parent, this);
        this.viewer = tableElement.getViewer();
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ComponentLabelProvider(this.getEditor(), this.Messages));
        tableElement.getButtonUp().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!VMenuEditor.this.viewer.getSelection().isEmpty() && (s = (IStructuredSelection)VMenuEditor.this.viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    EObject container = (EObject)VMenuEditor.this.getMaster().getValue();
                    int idx = ((List)container.eGet(VMenuEditor.this.feature)).indexOf(obj) - 1;
                    if (idx >= 0 && (cmd = MoveCommand.create((EditingDomain)VMenuEditor.this.getEditingDomain(), (Object)VMenuEditor.this.getMaster().getValue(), (Object)VMenuEditor.this.feature, (Object)obj, (int)idx)).canExecute()) {
                        VMenuEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        VMenuEditor.this.viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        tableElement.getButtonDown().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection s;
                if (!VMenuEditor.this.viewer.getSelection().isEmpty() && (s = (IStructuredSelection)VMenuEditor.this.viewer.getSelection()).size() == 1) {
                    Command cmd;
                    Object obj = s.getFirstElement();
                    EObject container = (EObject)VMenuEditor.this.getMaster().getValue();
                    List list = (List)container.eGet(VMenuEditor.this.feature);
                    int idx = list.indexOf(obj) + 1;
                    if (idx < list.size() && (cmd = MoveCommand.create((EditingDomain)VMenuEditor.this.getEditingDomain(), (Object)VMenuEditor.this.getMaster().getValue(), (Object)VMenuEditor.this.feature, (Object)obj, (int)idx)).canExecute()) {
                        VMenuEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                        VMenuEditor.this.viewer.setSelection((ISelection)new StructuredSelection(obj));
                    }
                }
            }
        });
        tableElement.getDropDown().setContentProvider((IContentProvider)new ArrayContentProvider());
        tableElement.getDropDown().setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element == Types.MENU) {
                    return ((VMenuEditor)VMenuEditor.this).Messages.MenuEditor_Label;
                }
                if (element == Types.POPUP_MENU) {
                    return ((VMenuEditor)VMenuEditor.this).Messages.PopupMenuEditor_TreeLabel;
                }
                return ((VMenuEditor)VMenuEditor.this).Messages.MenuEditor_Label_ViewMenu;
            }
        });
        tableElement.getDropDown().setInput((Object)Types.values());
        tableElement.getDropDown().setSelection((ISelection)new StructuredSelection((Object)Types.MENU));
        tableElement.getButtonAdd().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Types t = (Types)((Object)((IStructuredSelection)tableElement.getDropDown().getSelection()).getFirstElement());
                if (t == Types.MENU) {
                    VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.MENU);
                } else if (t == Types.POPUP_MENU) {
                    VMenuEditor.this.handleAdd(MenuPackageImpl.Literals.POPUP_MENU);
                } else {
                    VMenuEditor.this.handleAddViewMenu();
                }
            }
        });
        tableElement.getButtonRemove().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!VMenuEditor.this.viewer.getSelection().isEmpty()) {
                    List windows = ((IStructuredSelection)VMenuEditor.this.viewer.getSelection()).toList();
                    Command cmd = RemoveCommand.create((EditingDomain)VMenuEditor.this.getEditingDomain(), (Object)VMenuEditor.this.getMaster().getValue(), (Object)BasicPackageImpl.Literals.PART__MENUS, (Collection)windows);
                    if (cmd.canExecute()) {
                        VMenuEditor.this.getEditingDomain().getCommandStack().execute(cmd);
                    }
                }
            }
        });
        folder.setSelection(0);
        return folder;
    }

    @Override
    public IObservableList getChildList(Object element) {
        return null;
    }

    protected void handleAdd(EClass eClass) {
        EObject handler = EcoreUtil.create((EClass)eClass);
        this.setElementId(handler);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)this.feature, (Object)handler);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(handler);
        }
    }

    protected void handleAddViewMenu() {
        MMenu menu = MenuFactoryImpl.eINSTANCE.createMenu();
        menu.getTags().add(VIEW_MENU_TAG);
        this.setElementId(menu);
        Command cmd = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getMaster().getValue(), (Object)this.feature, (Object)menu);
        if (cmd.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(cmd);
            this.getEditor().setSelection(menu);
        }
    }

    @Override
    public List<Action> getActions(Object element) {
        ArrayList<Action> l = new ArrayList<Action>(super.getActions(element));
        l.addAll(this.actions);
        return l;
    }

    static enum Types {
        MENU,
        POPUP_MENU,
        VIEW_MENU;

    }
}

