/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.liveeditor;

import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.tools.emf.liveeditor.MemoryModelResource;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.wbm.ApplicationModelEditor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OpenLiveDialogHandler {
    private Shell shell;

    @Execute
    public void run(@Named(value="activeShell") Shell s, MApplication application, IStylingEngine engine) {
        if (this.shell == null || this.shell.isDisposed()) {
            try {
                this.shell = new Shell(s, 1264);
                this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
                this.shell.setBackgroundMode(1);
                FillLayout layout = new FillLayout();
                layout.marginHeight = 10;
                layout.marginWidth = 10;
                this.shell.setLayout((Layout)layout);
                IEclipseContext childContext = application.getContext().createChild("EditorContext");
                MemoryModelResource resource = new MemoryModelResource(application);
                childContext.set(IModelResource.class, (Object)resource);
                childContext.set(Composite.class.getName(), (Object)this.shell);
                childContext.set(Shell.class.getName(), (Object)this.shell);
                ContextInjectionFactory.make(ApplicationModelEditor.class, (IEclipseContext)childContext);
                this.shell.open();
                Display d = this.shell.getDisplay();
                while (!this.shell.isDisposed()) {
                    if (d.readAndDispatch()) continue;
                    d.sleep();
                }
                childContext.dispose();
                this.shell = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

