/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.editor3x;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.e4.tools.emf.editor3x.RefactorParticipantDelegate;
import org.eclipse.e4.tools.emf.editor3x.extension.Util;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;

public class ModelRenameParticipant
extends RenameParticipant {
    private IType _type;
    private IPackageFragment _pckage;
    private IFile _file;
    private IFolder _folder;

    protected boolean initialize(Object element) {
        if (element instanceof IType) {
            this._type = (IType)element;
            return true;
        }
        if (element instanceof IPackageFragment) {
            this._pckage = (IPackageFragment)element;
            return true;
        }
        if (element instanceof IFile) {
            this._file = (IFile)element;
            return true;
        }
        if (element instanceof IFolder) {
            this._folder = (IFolder)element;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Workbench Model Contribution Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this._type != null) {
            return this.createClassChange(pm, this._type);
        }
        if (this._pckage != null) {
            return this.createPackageChange(pm, this._pckage);
        }
        if (this._file != null) {
            return this.createFileChange(pm, this._file);
        }
        if (this._folder != null) {
            return this.createFolderChange(pm, this._folder);
        }
        return null;
    }

    private Change createFolderChange(IProgressMonitor pm, IFolder folder) throws CoreException {
        String SPLIT = "/";
        if (folder.getParent().getFullPath().segmentCount() == 1) {
            SPLIT = "";
        }
        String newUrl = "platform:/plugin/" + folder.getProject().getName() + "/" + folder.getParent().getProjectRelativePath().toString() + SPLIT + this.getArguments().getNewName();
        String oldUrl = "platform:/plugin" + folder.getFullPath();
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, oldUrl, newUrl);
    }

    private Change createFileChange(IProgressMonitor pm, IFile file) throws CoreException {
        String SPLIT = "/";
        if (file.getParent().getFullPath().segmentCount() == 1) {
            SPLIT = "";
        }
        String newUrl = "platform:/plugin/" + file.getProject().getName() + "/" + file.getParent().getProjectRelativePath().toString() + SPLIT + this.getArguments().getNewName();
        String oldUrl = "platform:/plugin" + file.getFullPath();
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, oldUrl, newUrl);
    }

    private Change createPackageChange(IProgressMonitor pm, IPackageFragment pckage) throws CoreException {
        String bundle = Util.getBundleSymbolicName(pckage.getJavaProject().getProject());
        String newUrl = "bundleclass://" + bundle + "/" + this.getArguments().getNewName();
        String oldUrl = "bundleclass://" + bundle + "/" + pckage.getElementName();
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, oldUrl, newUrl);
    }

    private Change createClassChange(IProgressMonitor pm, IType type) throws CoreException {
        String bundle = Util.getBundleSymbolicName(type.getJavaProject().getProject());
        String newUrl = "bundleclass://" + bundle + "/" + (type.getPackageFragment().getElementName().length() == 0 ? this.getArguments().getNewName() : String.valueOf(type.getPackageFragment().getElementName()) + "." + this.getArguments().getNewName());
        String oldUrl = "bundleclass://" + bundle + "/" + type.getFullyQualifiedName().replace(".", "\\.");
        return RefactorParticipantDelegate.createChange(pm, (RefactoringParticipant)this, oldUrl, newUrl);
    }
}

