/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.databinding.observable.list.ListDiffVisitor;
import org.eclipse.core.internal.databinding.observable.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListDiff<E>
implements IDiff {
    public abstract ListDiffEntry<?>[] getDifferences();

    public List<ListDiffEntry<E>> getDifferencesAsList() {
        ArrayList result = new ArrayList();
        if (this.getDifferences() != null) {
            ListDiffEntry<?>[] listDiffEntryArray = this.getDifferences();
            int n = listDiffEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ListDiffEntry<?> entry = listDiffEntryArray[n2];
                result.add(entry);
                ++n2;
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public void accept(ListDiffVisitor<E> visitor) {
        differences = this.getDifferencesAsList();
        i = 0;
        while (i < differences.size()) {
            block11: {
                block9: {
                    block7: {
                        block10: {
                            block8: {
                                entry = differences.get(i);
                                elem = entry.getElement();
                                pos = entry.getPosition();
                                add = entry.isAddition();
                                if (i + 1 >= differences.size() || add == (nextEntry = differences.get(i + 1)).isAddition()) ** GOTO lbl-1000
                                if (!add) break block7;
                                addPos = pos;
                                addElem = elem;
                                removePos = nextEntry.getPosition();
                                removeElem = nextEntry.getElement();
                                if (addPos <= removePos) break block8;
                                --addPos;
                                break block9;
                            }
                            if (removePos <= addPos) break block10;
                            --removePos;
                            break block9;
                        }
                        visitor.handleAdd(pos, elem);
                        break block11;
                    }
                    removePos = pos;
                    removeElem = elem;
                    addPos = nextEntry.getPosition();
                    addElem = nextEntry.getElement();
                }
                if (removePos == addPos) {
                    visitor.handleReplace(pos, removeElem, addElem);
                    ++i;
                } else if (Util.equals(removeElem, addElem)) {
                    visitor.handleMove(removePos, addPos, elem);
                    ++i;
                } else if (add) {
                    visitor.handleAdd(pos, elem);
                } else {
                    visitor.handleRemove(pos, elem);
                }
            }
            ++i;
        }
    }

    public boolean isEmpty() {
        return this.getDifferences().length == 0;
    }

    public void applyTo(final List<E> list) {
        this.accept(new ListDiffVisitor<E>(){

            @Override
            public void handleAdd(int index, E element) {
                list.add(index, element);
            }

            @Override
            public void handleRemove(int index, E element) {
                list.remove(index);
            }

            @Override
            public void handleReplace(int index, E oldElement, E newElement) {
                list.set(index, newElement);
            }
        });
    }

    public List<E> simulateOn(List<E> list) {
        class ResultReference {
            List<E> value;

            ResultReference() {
            }
        }
        final ResultReference result = new ResultReference();
        result.value = list;
        this.accept(new ListDiffVisitor<E>(){
            {
            }

            @Override
            public void handleAdd(int index, E element) {
                List first = result.value.subList(0, index);
                List middle = Collections.singletonList(element);
                List last = result.value.subList(index, result.value.size());
                result.value = ConcatList.cat(first, middle, last);
            }

            @Override
            public void handleRemove(int index, E element) {
                List first = result.value.subList(0, index);
                List last = result.value.subList(index + 1, result.value.size());
                result.value = ConcatList.cat(first, last);
            }

            @Override
            public void handleReplace(int index, E oldElement, E newElement) {
                List first = result.value.subList(0, index);
                List middle = Collections.singletonList(newElement);
                List last = result.value.subList(index + 1, result.value.size());
                result.value = ConcatList.cat(first, middle, last);
            }
        });
        return result.value;
    }

    public String toString() {
        List<ListDiffEntry<E>> differences = this.getDifferencesAsList();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getName());
        if (differences == null || differences.size() == 0) {
            buffer.append("{}");
        } else {
            buffer.append("{");
            int i = 0;
            while (i < differences.size()) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append("difference[").append(i).append("] [").append(differences.get(i) != null ? differences.get(i).toString() : "null").append("]");
                ++i;
            }
            buffer.append("}");
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConcatList<E>
    extends AbstractList<E> {
        private final List<E> firstSublist;
        private final List<E> middleSublist;
        private final List<E> lastSublist;

        public static <T> List<T> cat(List<T> a, List<T> b, List<T> c) {
            if (a.isEmpty()) {
                return ConcatList.cat(b, c);
            }
            if (b.isEmpty()) {
                return ConcatList.cat(a, c);
            }
            if (c.isEmpty()) {
                return ConcatList.cat(a, b);
            }
            return new ConcatList<T>(a, b, c);
        }

        public static <T> List<T> cat(List<T> a, List<T> b) {
            if (a.isEmpty()) {
                if (b.isEmpty()) {
                    return Collections.emptyList();
                }
                return b;
            }
            if (b.isEmpty()) {
                return a;
            }
            List c = Collections.emptyList();
            return new ConcatList<T>(a, b, c);
        }

        private ConcatList(List<E> firstSublist, List<E> middleSublist, List<E> lastSublist) {
            this.firstSublist = firstSublist;
            this.middleSublist = middleSublist;
            this.lastSublist = lastSublist;
        }

        @Override
        public E get(int index) {
            int subListIndex = index;
            if (subListIndex < this.firstSublist.size()) {
                return this.firstSublist.get(subListIndex);
            }
            if ((subListIndex -= this.firstSublist.size()) < this.middleSublist.size()) {
                return this.middleSublist.get(subListIndex);
            }
            if ((subListIndex -= this.middleSublist.size()) < this.lastSublist.size()) {
                return this.lastSublist.get(subListIndex);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return this.firstSublist.size() + this.middleSublist.size() + this.lastSublist.size();
        }
    }
}

