/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.internal.databinding.observable.Util;
import org.eclipse.core.runtime.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateAndTimeObservableValue
extends AbstractObservableValue<Date> {
    private IObservableValue<Date> dateObservable;
    private IObservableValue<Date> timeObservable;
    private PrivateChangeInterface privateChangeInterface;
    private PrivateStaleInterface privateStaleInterface;
    private PrivateDisposeInterface privateDisposeInterface;
    private Date cachedValue;
    private boolean updating;
    private static final ThreadLocal<Calendar> calendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    public DateAndTimeObservableValue(IObservableValue<Date> dateObservable, IObservableValue<Date> timeObservable) {
        super(dateObservable.getRealm());
        this.dateObservable = dateObservable;
        this.timeObservable = timeObservable;
        Assert.isTrue((boolean)dateObservable.getRealm().equals(timeObservable.getRealm()));
        this.privateChangeInterface = new PrivateChangeInterface();
        this.privateStaleInterface = new PrivateStaleInterface();
        this.privateDisposeInterface = new PrivateDisposeInterface();
        dateObservable.addDisposeListener(this.privateDisposeInterface);
        timeObservable.addDisposeListener(this.privateDisposeInterface);
    }

    @Override
    public Object getValueType() {
        return Date.class;
    }

    @Override
    protected void firstListenerAdded() {
        this.cachedValue = this.doGetValue();
        this.dateObservable.addChangeListener(this.privateChangeInterface);
        this.dateObservable.addStaleListener(this.privateStaleInterface);
        this.timeObservable.addChangeListener(this.privateChangeInterface);
        this.timeObservable.addStaleListener(this.privateStaleInterface);
    }

    @Override
    protected void lastListenerRemoved() {
        if (this.dateObservable != null && !this.dateObservable.isDisposed()) {
            this.dateObservable.removeChangeListener(this.privateChangeInterface);
            this.dateObservable.removeStaleListener(this.privateStaleInterface);
        }
        if (this.timeObservable != null && !this.timeObservable.isDisposed()) {
            this.timeObservable.removeChangeListener(this.privateChangeInterface);
            this.timeObservable.removeStaleListener(this.privateStaleInterface);
        }
        this.cachedValue = null;
    }

    private void notifyIfChanged() {
        Date newValue;
        Date oldValue;
        if (this.hasListeners() && !Util.equals(oldValue = this.cachedValue, newValue = (this.cachedValue = this.doGetValue()))) {
            this.fireValueChange(Diffs.createValueDiff(oldValue, newValue));
        }
    }

    @Override
    protected Date doGetValue() {
        Date dateValue = this.dateObservable.getValue();
        if (dateValue == null) {
            return null;
        }
        Date timeValue = this.timeObservable.getValue();
        Calendar cal = calendar.get();
        cal.setTime(dateValue);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        if (timeValue == null) {
            cal.clear();
        } else {
            cal.setTime(timeValue);
        }
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millis = cal.get(14);
        cal.set(year, month, day, hour, minute, second);
        cal.set(14, millis);
        return cal.getTime();
    }

    @Override
    protected void doSetValue(Date combinedDate) {
        Date dateValue;
        Calendar cal = calendar.get();
        if (combinedDate == null) {
            cal.clear();
        } else {
            cal.setTime(combinedDate);
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int millis = cal.get(14);
        if (combinedDate == null) {
            dateValue = null;
        } else {
            dateValue = this.dateObservable.getValue();
            if (dateValue == null) {
                cal.clear();
            } else {
                cal.setTime(dateValue);
            }
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, day);
            dateValue = cal.getTime();
        }
        Date timeValue = this.timeObservable.getValue();
        if (timeValue == null) {
            cal.clear();
        } else {
            cal.setTime(timeValue);
        }
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        cal.set(14, millis);
        timeValue = cal.getTime();
        this.updating = true;
        try {
            this.dateObservable.setValue(dateValue);
            this.timeObservable.setValue(timeValue);
        }
        finally {
            this.updating = false;
        }
        this.notifyIfChanged();
    }

    @Override
    public boolean isStale() {
        ObservableTracker.getterCalled(this);
        return this.dateObservable.isStale() || this.timeObservable.isStale();
    }

    @Override
    public synchronized void dispose() {
        this.checkRealm();
        if (!this.isDisposed()) {
            if (!this.dateObservable.isDisposed()) {
                this.dateObservable.removeDisposeListener(this.privateDisposeInterface);
                this.dateObservable.removeChangeListener(this.privateChangeInterface);
                this.dateObservable.removeStaleListener(this.privateStaleInterface);
            }
            if (!this.timeObservable.isDisposed()) {
                this.timeObservable.removeDisposeListener(this.privateDisposeInterface);
                this.timeObservable.removeChangeListener(this.privateChangeInterface);
                this.timeObservable.removeStaleListener(this.privateStaleInterface);
            }
            this.dateObservable = null;
            this.timeObservable = null;
            this.privateChangeInterface = null;
            this.privateStaleInterface = null;
            this.privateDisposeInterface = null;
            this.cachedValue = null;
        }
        super.dispose();
    }

    private class PrivateChangeInterface
    implements IChangeListener {
        private PrivateChangeInterface() {
        }

        public void handleChange(ChangeEvent event) {
            if (!DateAndTimeObservableValue.this.isDisposed() && !DateAndTimeObservableValue.this.updating) {
                DateAndTimeObservableValue.this.notifyIfChanged();
            }
        }
    }

    private class PrivateDisposeInterface
    implements IDisposeListener {
        private PrivateDisposeInterface() {
        }

        public void handleDispose(DisposeEvent staleEvent) {
            DateAndTimeObservableValue.this.dispose();
        }
    }

    private class PrivateStaleInterface
    implements IStaleListener {
        private PrivateStaleInterface() {
        }

        public void handleStale(StaleEvent staleEvent) {
            if (!DateAndTimeObservableValue.this.isDisposed()) {
                DateAndTimeObservableValue.this.fireStale();
            }
        }
    }
}

