/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.value;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ComputedValue<T>
extends AbstractObservableValue<T> {
    private boolean dirty = true;
    private boolean stale = false;
    private T cachedValue = null;
    private IObservable[] dependencies = null;
    private IChangeListener privateChangeInterface = new PrivateChangeInterface();
    private IStaleListener privateStaleInterface = new PrivateStaleInterface();
    private Runnable privateRunnableInterface = new PrivateRunnableInterface();
    private Object valueType;

    public ComputedValue() {
        this(Realm.getDefault(), null);
    }

    public ComputedValue(Object valueType) {
        this(Realm.getDefault(), valueType);
    }

    public ComputedValue(Realm realm) {
        this(realm, null);
    }

    public ComputedValue(Realm realm, Object valueType) {
        super(realm);
        this.valueType = valueType;
    }

    @Override
    protected final T doGetValue() {
        if (this.dirty) {
            IObservable[] newDependencies = ObservableTracker.runAndMonitor(this.privateRunnableInterface, this.privateChangeInterface, null);
            this.stale = false;
            int i = 0;
            while (i < newDependencies.length) {
                IObservable observable = newDependencies[i];
                if (observable.isStale()) {
                    this.stale = true;
                } else {
                    observable.addStaleListener(this.privateStaleInterface);
                }
                ++i;
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedValue;
    }

    protected abstract T calculate();

    protected final void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.stopListening();
            final T oldValue = this.cachedValue;
            this.fireValueChange(new ValueDiff<T>(){

                @Override
                public T getOldValue() {
                    return oldValue;
                }

                @Override
                public T getNewValue() {
                    return ComputedValue.this.getValue();
                }
            });
        }
    }

    private void stopListening() {
        if (this.dependencies != null) {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener(this.privateChangeInterface);
                observable.removeStaleListener(this.privateStaleInterface);
                ++i;
            }
            this.dependencies = null;
        }
    }

    @Override
    public boolean isStale() {
        this.getValue();
        return this.stale;
    }

    @Override
    public Object getValueType() {
        return this.valueType;
    }

    @Override
    protected boolean hasListeners() {
        return super.hasListeners();
    }

    @Override
    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeValueForListeners();
    }

    private void computeValueForListeners() {
        this.getRealm().exec(new Runnable(){

            public void run() {
                if (ComputedValue.this.dependencies == null && ComputedValue.this.hasListeners()) {
                    ComputedValue.this.getValue();
                }
            }
        });
    }

    @Override
    public synchronized void addValueChangeListener(IValueChangeListener<T> listener) {
        super.addValueChangeListener(listener);
        this.computeValueForListeners();
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.stopListening();
    }

    private class PrivateChangeInterface
    implements IChangeListener {
        private PrivateChangeInterface() {
        }

        public void handleChange(ChangeEvent event) {
            ComputedValue.this.makeDirty();
        }
    }

    private class PrivateRunnableInterface
    implements Runnable {
        private PrivateRunnableInterface() {
        }

        public void run() {
            ComputedValue.this.cachedValue = ComputedValue.this.calculate();
        }
    }

    private class PrivateStaleInterface
    implements IStaleListener {
        private PrivateStaleInterface() {
        }

        public void handleStale(StaleEvent event) {
            if (!ComputedValue.this.dirty && !ComputedValue.this.stale) {
                ComputedValue.this.stale = true;
                ComputedValue.this.fireStale();
            }
        }
    }
}

