/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimElement;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.BasicFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.AbstractGroupMarker;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.menus.MenuHelper;
import org.eclipse.ui.menus.CommandContributionItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoolBarToTrimManager
extends ContributionManager
implements ICoolBarManager2 {
    private static final String TOOLBAR_SEPARATOR = "toolbarSeparator";
    private static final String MAIN_TOOLBAR_ID = "org.eclipse.ui.main.toolbar";
    private static final String OBJECT = "coolbar.object";
    private MTrimBar trimBar;
    private List<MTrimElement> workbenchTrimElements;
    private IRendererFactory rendererFactory;
    private ToolBarManagerRenderer renderer;
    private MApplication application;
    private MTrimmedWindow window;

    public CoolBarToTrimManager(MApplication app, MTrimmedWindow window, List<MTrimElement> workbenchTrimElements, IRendererFactory rf) {
        this.application = app;
        this.window = window;
        this.rendererFactory = rf;
        this.workbenchTrimElements = workbenchTrimElements;
        this.trimBar = BasicFactoryImpl.eINSTANCE.createTrimBar();
        this.trimBar.setElementId(MAIN_TOOLBAR_ID);
        this.renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)MenuFactoryImpl.eINSTANCE.createToolBar(), null);
    }

    public void add(IAction action) {
    }

    public void add(IContributionItem item) {
        this.add(-1, item);
    }

    private void add(int idx, IContributionItem item) {
        if (item instanceof IToolBarContributionItem) {
            IToolBarManager mgr = ((IToolBarContributionItem)item).getToolBarManager();
            if (!(mgr instanceof ToolBarManager)) {
                return;
            }
            ToolBarManager manager = (ToolBarManager)mgr;
            if (this.renderer.getToolBarModel(manager) != null) {
                return;
            }
            MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
            toolBar.setElementId(item.getId());
            toolBar.getTransientData().put(OBJECT, item);
            if (manager instanceof ToolBarManager) {
                this.renderer.linkModelToManager(toolBar, manager);
            }
            toolBar.setToBeRendered(true);
            if (idx < 0) {
                this.trimBar.getChildren().add(toolBar);
            } else {
                this.trimBar.getChildren().add(idx, toolBar);
            }
            this.workbenchTrimElements.add((MTrimElement)toolBar);
        } else if (item instanceof IContributionManager) {
            new Exception("Have to deal with " + item).printStackTrace();
        } else if (item instanceof AbstractGroupMarker) {
            if (item.getId() == null) {
                return;
            }
            for (MTrimElement toolBar : this.trimBar.getChildren()) {
                if (!item.getId().equals(toolBar.getElementId()) || !toolBar.getTags().contains(TOOLBAR_SEPARATOR)) continue;
                return;
            }
            MToolBarSeparator separator = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
            separator.setToBeRendered(false);
            separator.setElementId(item.getId());
            MToolBar toolBar = MenuFactoryImpl.eINSTANCE.createToolBar();
            toolBar.getTransientData().put(OBJECT, item);
            toolBar.getTags().add(TOOLBAR_SEPARATOR);
            toolBar.setElementId(item.getId());
            toolBar.getChildren().add(separator);
            toolBar.setToBeRendered(false);
            if (idx < 0) {
                this.trimBar.getChildren().add(toolBar);
            } else {
                this.trimBar.getChildren().add(idx, toolBar);
            }
            this.workbenchTrimElements.add((MTrimElement)toolBar);
        }
    }

    public void add(IToolBarManager toolBarManager) {
        if (toolBarManager instanceof ToolBarManager) {
            this.add((IContributionItem)new ToolBarContributionItem(toolBarManager));
        }
    }

    public void appendToGroup(String groupName, IAction action) {
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        boolean foundGroup = false;
        List children = this.trimBar.getChildren();
        int i = 0;
        while (i < children.size()) {
            MTrimElement el = (MTrimElement)children.get(i);
            if (groupName.equals(el.getElementId()) && el.getTags().contains(TOOLBAR_SEPARATOR)) {
                foundGroup = true;
            } else if (foundGroup && el.getTags().contains(TOOLBAR_SEPARATOR)) {
                this.add(i, item);
                return;
            }
            ++i;
        }
        this.add(-1, item);
    }

    public Control createControl2(Composite parent) {
        new Exception("CBTTM:createControl2()").printStackTrace();
        return null;
    }

    public void dispose() {
    }

    public IContributionItem find(String id) {
        for (MTrimElement el : this.trimBar.getChildren()) {
            if (!id.equals(el.getElementId()) || !(el instanceof MToolBar)) continue;
            final MToolBar model = (MToolBar)el;
            if (model.getTransientData().get(OBJECT) != null) {
                return (IContributionItem)model.getTransientData().get(OBJECT);
            }
            ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)model, null);
            ToolBarManager manager = renderer.getManager(model);
            if (manager != null) {
                ToolBarContributionItem toolBarContributionItem = new ToolBarContributionItem((IToolBarManager)manager, model.getElementId()){

                    public void setVisible(boolean visible) {
                        super.setVisible(visible);
                        model.setVisible(visible);
                    }
                };
                model.getTransientData().put(OBJECT, toolBarContributionItem);
                return toolBarContributionItem;
            }
            if (model.getTags().contains(TOOLBAR_SEPARATOR)) {
                if (model.getTransientData().get(OBJECT) != null) {
                    return (IContributionItem)model.getTransientData().get(OBJECT);
                }
                return new GroupMarker(model.getElementId());
            }
            return null;
        }
        return null;
    }

    public IMenuManager getContextMenuManager() {
        new Exception("CBTTM:getContextMenuManager()").printStackTrace();
        return null;
    }

    public Control getControl2() {
        new Exception("CBTTM:getControl2()").printStackTrace();
        return null;
    }

    public IContributionItem[] getItems() {
        new Exception("CBTTM:getItems()").printStackTrace();
        return new IContributionItem[0];
    }

    public boolean getLockLayout() {
        return false;
    }

    public IContributionManagerOverrides getOverrides() {
        return null;
    }

    public int getStyle() {
        return 0;
    }

    public void insertAfter(String id, IAction action) {
    }

    public void insertAfter(String id, IContributionItem item) {
        List children = this.trimBar.getChildren();
        int i = 0;
        while (i < children.size()) {
            MTrimElement el = (MTrimElement)children.get(i);
            if (id.equals(el.getElementId())) {
                this.add(i + 1 < children.size() ? i + 1 : -1, item);
                return;
            }
            ++i;
        }
    }

    public void insertBefore(String id, IAction action) {
    }

    public void insertBefore(String id, IContributionItem item) {
        List children = this.trimBar.getChildren();
        int i = 0;
        while (i < children.size()) {
            MTrimElement el = (MTrimElement)children.get(i);
            if (id.equals(el.getElementId())) {
                this.add(i, item);
                return;
            }
            ++i;
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isEmpty() {
        return this.trimBar.getChildren().isEmpty();
    }

    public void markDirty() {
    }

    public void prependToGroup(String groupName, IAction action) {
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        List children = this.trimBar.getChildren();
        int i = 0;
        while (i < children.size()) {
            MTrimElement el = (MTrimElement)children.get(i);
            if (groupName.equals(el.getElementId()) && el.getTags().contains(TOOLBAR_SEPARATOR)) {
                this.add(i + 1 < children.size() ? i + 1 : -1, item);
                return;
            }
            ++i;
        }
        this.add(-1, item);
    }

    public void refresh() {
    }

    public IContributionItem remove(IContributionItem item) {
        List children = this.trimBar.getChildren();
        int i = 0;
        while (i < children.size()) {
            MTrimElement child = (MTrimElement)children.get(i);
            Object obj = child.getTransientData().get(OBJECT);
            if (obj != null && obj.equals(item)) {
                IToolBarManager parent;
                if (child instanceof MToolBarElement) {
                    this.renderer.clearModelToContribution((MToolBarElement)child, item);
                }
                if (child instanceof MToolBar && item instanceof IToolBarContributionItem && (parent = ((IToolBarContributionItem)item).getToolBarManager()) instanceof ToolBarManager) {
                    this.renderer.clearModelToManager((MToolBar)child, (ToolBarManager)parent);
                }
                ((MTrimElement)children.get(i)).setToBeRendered(false);
                children.remove(i);
                return (IContributionItem)obj;
            }
            if (item.getId() != null && item.getId().equals(child.getElementId())) {
                new Exception("CBTTM:remove(IContributionItem item) " + item + "\n\t" + child).printStackTrace();
            }
            ++i;
        }
        return null;
    }

    public IContributionItem remove(String id) {
        new Exception("CBTTM:remove(String id) " + id).printStackTrace();
        return null;
    }

    public void removeAll() {
        new Exception("CBTTM:removeAll").printStackTrace();
    }

    public void resetItemOrder() {
        new Exception("CBTTM:resetItemOrder").printStackTrace();
    }

    public void setContextMenuManager(IMenuManager menuManager) {
    }

    public void setItems(IContributionItem[] newItems) {
        new Exception("CBTTM:setItems(IContributionItem[] newItems)").printStackTrace();
    }

    public void setLockLayout(boolean value) {
    }

    public void setOverrides(IContributionManagerOverrides newOverrides) {
    }

    public void update(boolean force) {
        for (MTrimElement el : this.trimBar.getChildren()) {
            ToolBarManagerRenderer renderer;
            ToolBarManager manager;
            if (!(el instanceof MToolBar) || (manager = (renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)el, null)).getManager((MToolBar)el)) == null) continue;
            this.fill((MToolBar)el, (IContributionManager)manager);
        }
        List trimBars = this.window.getTrimBars();
        if (trimBars.size() == 0 || trimBars.get(0) != this.trimBar) {
            trimBars.add(0, this.trimBar);
        }
    }

    private void fill(MToolBar container, IContributionManager manager) {
        ToolBarManagerRenderer renderer = (ToolBarManagerRenderer)this.rendererFactory.getRenderer((MUIElement)container, null);
        IContributionItem[] iContributionItemArray = manager.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item != null && renderer.getToolElement(item) == null) {
                MToolItem toolItem;
                if (item instanceof IToolBarContributionItem) {
                    IToolBarManager manager2 = ((IToolBarContributionItem)item).getToolBarManager();
                    new Exception("fill(MToolBar container, IContributionManager manager) with " + item + " to " + manager2).printStackTrace();
                    this.fill(container, (IContributionManager)manager2);
                } else if (item instanceof IContributionManager) {
                    new Exception("fill(MToolBar container, IContributionManager manager) with rogue contribution manager: " + item).printStackTrace();
                    this.fill(container, (IContributionManager)item);
                } else if (item instanceof CommandContributionItem) {
                    CommandContributionItem cci = (CommandContributionItem)item;
                    toolItem = MenuHelper.createToolItem(this.application, cci);
                    manager.remove(item);
                    if (toolItem != null) {
                        container.getChildren().add(toolItem);
                    }
                } else if (item instanceof AbstractGroupMarker) {
                    MToolBarSeparator separator = MenuFactoryImpl.eINSTANCE.createToolBarSeparator();
                    separator.setToBeRendered(item.isVisible());
                    separator.setVisible(false);
                    separator.setElementId(item.getId());
                    container.getChildren().add(separator);
                    manager.remove(item);
                } else if (item instanceof ActionContributionItem) {
                    IAction action = ((ActionContributionItem)item).getAction();
                    if (action.getStyle() == 4) {
                        toolItem = MenuFactoryImpl.eINSTANCE.createOpaqueToolItem();
                        toolItem.setElementId(item.getId());
                        container.getChildren().add(toolItem);
                        renderer.linkModelToContribution((MToolBarElement)toolItem, item);
                    } else {
                        toolItem = MenuHelper.createToolItem(this.application, (ActionContributionItem)item);
                        manager.remove(item);
                        if (toolItem != null) {
                            container.getChildren().add(toolItem);
                        }
                    }
                } else {
                    MOpaqueToolItem toolItem2 = MenuFactoryImpl.eINSTANCE.createOpaqueToolItem();
                    toolItem2.setElementId(item.getId());
                    container.getChildren().add(toolItem2);
                    renderer.linkModelToContribution((MToolBarElement)toolItem2, item);
                }
            }
            ++n2;
        }
    }
}

