/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MOpaqueMenuSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.e4.ui.workbench.swt.modeling.MenuService;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.menus.IMenuService;

public class PopupMenuExtender
implements IMenuListener2,
IRegistryChangeListener {
    private static final int STATIC_ACTION_READ = 1;
    private static final int INCLUDE_EDITOR_INPUT = 2;
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private Map staticActionBuilders = null;
    private int bitSet = 0;
    private ArrayList actionContributionCache = new ArrayList();
    private ArrayList managerContributionCache = new ArrayList();
    private boolean cleanupNeeded = false;
    private MPart modelPart;
    private MPopupMenu menuModel;

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part) {
        this(id, menu, prov, part, true);
    }

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part, boolean includeEditorInput) {
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        this.modelPart = (MPart)part.getSite().getService(MPart.class);
        if (includeEditorInput) {
            this.bitSet |= 2;
        }
        menu.addMenuListener((IMenuListener)this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menu);
            this.menuWrapper.setVisible(true);
        }
        this.createModelFor(id);
        this.addMenuId(id);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    private void createModelFor(String id) {
        IRendererFactory factory;
        AbstractPartRenderer obj;
        if (id == null) {
            id = String.valueOf(this.getClass().getName()) + '.' + System.identityHashCode(this);
        }
        this.menuModel = null;
        for (MMenu item : this.modelPart.getMenus()) {
            if (!id.equals(item.getElementId()) || !(item instanceof MPopupMenu) || !item.getTags().contains("popup")) continue;
            this.menuModel = (MPopupMenu)item;
            break;
        }
        if (this.menuModel == null) {
            this.menuModel = MenuFactoryImpl.eINSTANCE.createPopupMenu();
            this.menuModel.setElementId(id);
            this.menuModel.getTags().add("menuContribution:popup");
            this.modelPart.getMenus().add(this.menuModel);
        }
        if ((obj = (factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class)).getRenderer((MUIElement)this.menuModel, null)) instanceof MenuManagerRenderer) {
            ((MenuManagerRenderer)obj).linkModelToManager((MMenu)this.menuModel, this.menu);
        }
        this.registerE4Support();
    }

    private void registerE4Support() {
        if (this.menuModel.getWidget() == null && this.menu.getMenu() != null) {
            MenuService.registerMenu((Control)this.menu.getMenu().getParent(), (MPopupMenu)this.menuModel, (MPart)this.modelPart);
        }
    }

    public Set getMenuIds() {
        if (this.staticActionBuilders == null) {
            return Collections.EMPTY_SET;
        }
        return this.staticActionBuilders.keySet();
    }

    public final void addMenuId(String menuId) {
        String tag;
        List tags;
        this.bitSet &= 0xFFFFFFFE;
        if (this.menuModel != null && !(tags = this.menuModel.getTags()).contains(tag = "popup:" + menuId)) {
            tags.add(tag);
        }
        this.readStaticActionsFor(menuId);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider selectionProvider, IWorkbenchPart part) {
        return this.menu == menuManager && this.selProvider == selectionProvider && this.part == part;
    }

    private void addEditorActions(IMenuManager mgr) {
        ISelectionProvider activeEditor = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{editorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public void setSelection(ISelection selection) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, activeEditor)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addObjectActions(IMenuManager mgr) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private final void clearStaticActions() {
        this.bitSet &= 0xFFFFFFFE;
        if (this.staticActionBuilders != null) {
            for (Object staticActionBuilder : this.staticActionBuilders.values()) {
                if (!(staticActionBuilder instanceof ViewerActionBuilder)) continue;
                ((ViewerActionBuilder)staticActionBuilder).dispose();
            }
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilders != null) {
            for (ViewerActionBuilder staticActionBuilder : this.staticActionBuilders.values()) {
                staticActionBuilder.contribute(mgr, null, true);
            }
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        IWorkbench workbench;
        this.registerE4Support();
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            Workbench realWorkbench = (Workbench)workbench;
            this.runCleanUp(realWorkbench);
            StructuredSelection input = null;
            if ((this.bitSet & 2) != 0 && this.part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)this.part;
                input = new StructuredSelection(new Object[]{editorPart.getEditorInput()});
            }
            ISelection s = this.selProvider == null ? null : this.selProvider.getSelection();
            realWorkbench.addShowingMenus(this.getMenuIds(), s, (ISelection)input);
        }
        this.addMenuContributions(mgr);
        this.readStaticActions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        if ((this.bitSet & 2) != 0) {
            this.addEditorActions(mgr);
        }
        this.addObjectActions(mgr);
        this.addStaticActions(mgr);
    }

    private void addMenuContributions(IMenuManager mgr) {
        IRendererFactory factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class);
        AbstractPartRenderer obj = factory.getRenderer((MUIElement)this.menuModel, null);
        if (obj instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
            renderer.reconcileManagerToModel(this.menu, (MMenu)this.menuModel);
            renderer.processContributions((MMenu)this.menuModel, false, true);
            renderer.processContents((MElementContainer)this.menuModel);
        }
    }

    public final void menuAboutToHide(IMenuManager mgr) {
        IWorkbench workbench;
        this.gatherContributions(mgr);
        this.cleanupNeeded = true;
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Workbench realWorkbench = (Workbench)workbench;
                    PopupMenuExtender.this.runCleanUp(realWorkbench);
                }
            });
        }
    }

    private void runCleanUp(Workbench realWorkbench) {
        if (!this.cleanupNeeded) {
            return;
        }
        this.cleanupNeeded = false;
        realWorkbench.removeShowingMenus(this.getMenuIds(), null, null);
        this.cleanUpContributionCache();
    }

    private void gatherContributions(IMenuManager mgr) {
        IContributionItem[] items = mgr.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof PluginActionContributionItem) {
                this.actionContributionCache.add(items[i]);
            } else if (items[i] instanceof IMenuManager) {
                if (items[i] instanceof ContributionManager) {
                    this.managerContributionCache.add(items[i]);
                }
                this.gatherContributions((IMenuManager)items[i]);
            }
            ++i;
        }
    }

    private void cleanUpContributionCache() {
        IRendererFactory factory;
        AbstractPartRenderer obj;
        if (!this.actionContributionCache.isEmpty()) {
            PluginActionContributionItem[] items = this.actionContributionCache.toArray(new PluginActionContributionItem[this.actionContributionCache.size()]);
            this.actionContributionCache.clear();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
        }
        if ((obj = (factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class)).getRenderer((MUIElement)this.menuModel, null)) instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
            renderer.cleanUp((MMenu)this.menuModel);
        }
        this.managerContributionCache.clear();
    }

    private final void readStaticActions() {
        if (this.staticActionBuilders != null) {
            for (String menuId : this.staticActionBuilders.keySet()) {
                this.readStaticActionsFor(menuId);
            }
        }
    }

    private void readStaticActionsFor(String menuId) {
        Object object;
        if ((this.bitSet & 1) != 0) {
            return;
        }
        this.bitSet |= 1;
        if (menuId == null || menuId.length() < 1) {
            return;
        }
        if (this.staticActionBuilders == null) {
            this.staticActionBuilders = new HashMap();
        }
        if (!((object = this.staticActionBuilders.get(menuId)) instanceof ViewerActionBuilder)) {
            object = new ViewerActionBuilder();
            this.staticActionBuilders.put(menuId, object);
        }
        ViewerActionBuilder staticActionBuilder = (ViewerActionBuilder)object;
        staticActionBuilder.readViewerContributions(menuId, this.selProvider, this.part);
    }

    public void dispose() {
        IRendererFactory factory;
        AbstractPartRenderer obj;
        this.clearStaticActions();
        IMenuService menuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.releaseContributions((ContributionManager)this.menu);
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.menu.removeMenuListener((IMenuListener)this);
        if (this.menuModel != null && (obj = (factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class)).getRenderer((MUIElement)this.menuModel, null)) instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
            this.unlink(renderer, (MMenu)this.menuModel);
            renderer.clearModelToManager((MMenu)this.menuModel, this.menu);
        }
    }

    private void unlink(MenuManagerRenderer renderer, MMenu menu) {
        for (MMenuElement menuElement : menu.getChildren()) {
            Object item;
            MOpaqueMenuItem opaqueMenuItem;
            if (menuElement instanceof MOpaqueMenuItem) {
                opaqueMenuItem = (MOpaqueMenuItem)menuElement;
                item = opaqueMenuItem.getOpaqueItem();
                if (!(item instanceof IContributionItem)) continue;
                renderer.clearModelToContribution((MMenuElement)opaqueMenuItem, (IContributionItem)item);
                opaqueMenuItem.setOpaqueItem(null);
                continue;
            }
            if (menuElement instanceof MOpaqueMenuSeparator) {
                opaqueMenuItem = (MOpaqueMenuSeparator)menuElement;
                item = opaqueMenuItem.getOpaqueItem();
                if (!(item instanceof IContributionItem)) continue;
                renderer.clearModelToContribution((MMenuElement)opaqueMenuItem, (IContributionItem)item);
                opaqueMenuItem.setOpaqueItem(null);
                continue;
            }
            if (menuElement instanceof MMenu) {
                MMenu subMenu = (MMenu)menuElement;
                this.unlink(renderer, subMenu);
                MenuManager manager = renderer.getManager(subMenu);
                if (manager == null) continue;
                renderer.clearModelToManager(subMenu, manager);
                continue;
            }
            IContributionItem contribution = renderer.getContribution(menuElement);
            if (contribution == null) continue;
            renderer.clearModelToContribution(menuElement, contribution);
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        Display display = Display.getDefault();
        if (this.part != null) {
            display = this.part.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        int i = 0;
        while (i < deltas.length) {
            IExtensionDelta delta = deltas[i];
            IExtensionPoint extensionPoint = delta.getExtensionPoint();
            if (extensionPoint.getNamespace().equals(WorkbenchPlugin.PI_WORKBENCH) && extensionPoint.getSimpleIdentifier().equals("popupMenus")) {
                boolean clearPopups = false;
                IConfigurationElement[] elements = delta.getExtension().getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals("viewerContribution")) {
                        clearPopups = true;
                        break;
                    }
                    ++j;
                }
                if (clearPopups) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            PopupMenuExtender.this.clearStaticActions();
                        }
                    });
                }
            }
            ++i;
        }
    }

    public MenuManager getManager() {
        return this.menu;
    }
}

