/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.help.internal.base.remote.DefaultPreferenceFileHandler;
import org.eclipse.help.internal.base.remote.PreferenceFileHandler;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.remote.RemoteIC;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.preferences.HelpContentBlock;
import org.eclipse.help.ui.internal.preferences.InfocenterDisplay;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HelpContentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InfocenterDisplay remoteICPage;
    private Button searchLocalHelpOnly;
    private Button searchLocalHelpFirst;
    private Button searchLocalHelpLast;
    private Label descLabel;
    private Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            boolean isRemoteHelpEnabled;
            HelpContentBlock currentBlock = HelpContentPreferencePage.this.remoteICPage.getHelpContentBlock();
            boolean bl = isRemoteHelpEnabled = !HelpContentPreferencePage.this.searchLocalHelpOnly.getSelection();
            if (isRemoteHelpEnabled) {
                currentBlock.restoreDefaultButtons();
            } else {
                currentBlock.disableAllButtons();
            }
            currentBlock.getRemoteICviewer().getTable().setEnabled(isRemoteHelpEnabled);
        }
    };

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        this.initializeDialogUnits((Control)parent);
        this.descLabel = new Label(parent, 0);
        this.descLabel.setText(Messages.HelpContentPage_title);
        Dialog.applyDialogFont((Control)this.descLabel);
        this.createSearchLocalHelpOnly(parent);
        this.createSearchLocalHelpFirst(parent);
        this.createSearchLocalHelpLast(parent);
        this.remoteICPage = new InfocenterDisplay(this);
        this.remoteICPage.createContents(parent);
        this.initializeTableEnablement(this.searchLocalHelpOnly.getSelection());
        return parent;
    }

    protected void performDefaults() {
        super.performDefaults();
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        currentBlock.getRemoteICviewer().getRemoteICList().removeAllRemoteICs(currentBlock.getRemoteICList());
        currentBlock.getRemoteICviewer().getRemoteICList().loadDefaultPreferences();
        currentBlock.restoreDefaultButtons();
        boolean remoteHelpOn = new DefaultPreferenceFileHandler().isRemoteHelpOn();
        boolean remoteHelpPreferred = new DefaultPreferenceFileHandler().isRemoteHelpPreferred();
        this.searchLocalHelpOnly.setSelection(!remoteHelpOn);
        this.searchLocalHelpFirst.setSelection(remoteHelpOn && !remoteHelpPreferred);
        this.searchLocalHelpLast.setSelection(remoteHelpOn && remoteHelpPreferred);
        this.changeListener.handleEvent(null);
    }

    public boolean performOk() {
        InstanceScope instanceScope = new InstanceScope();
        IEclipsePreferences prefs = instanceScope.getNode("org.eclipse.help.base");
        prefs.putBoolean("remoteHelpOn", !this.searchLocalHelpOnly.getSelection());
        prefs.putBoolean("remoteHelpPreferred", this.searchLocalHelpLast.getSelection());
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        RemoteIC[] currentRemoteICArray = currentBlock.getRemoteICList();
        PreferenceFileHandler.commitRemoteICs((RemoteIC[])currentRemoteICArray);
        RemoteHelp.notifyPreferenceChange();
        return super.performOk();
    }

    protected GridData setButtonLayoutData(Button button) {
        return super.setButtonLayoutData(button);
    }

    private void createSearchLocalHelpOnly(Composite parent) {
        this.searchLocalHelpOnly = new Button(parent, 16);
        this.searchLocalHelpOnly.setText(Messages.SearchEmbeddedHelpOnly);
        this.searchLocalHelpOnly.addListener(13, this.changeListener);
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        this.searchLocalHelpOnly.setSelection(!isRemoteOn);
        Dialog.applyDialogFont((Control)this.searchLocalHelpOnly);
    }

    private void createSearchLocalHelpFirst(Composite parent) {
        this.searchLocalHelpFirst = new Button(parent, 16);
        this.searchLocalHelpFirst.setText(Messages.SearchEmbeddedHelpFirst);
        this.searchLocalHelpFirst.addListener(13, this.changeListener);
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        boolean isRemotePreferred = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpPreferred", false, null);
        this.searchLocalHelpFirst.setSelection(isRemoteOn && !isRemotePreferred);
        Dialog.applyDialogFont((Control)this.searchLocalHelpFirst);
    }

    private void createSearchLocalHelpLast(Composite parent) {
        this.searchLocalHelpLast = new Button(parent, 16);
        this.searchLocalHelpLast.setText(Messages.SearchEmbeddedHelpLast);
        this.searchLocalHelpLast.addListener(13, this.changeListener);
        boolean isRemoteOn = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpOn", false, null);
        boolean isRemotePreferred = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "remoteHelpPreferred", false, null);
        this.searchLocalHelpLast.setSelection(isRemoteOn && isRemotePreferred);
        Dialog.applyDialogFont((Control)this.searchLocalHelpLast);
    }

    private void initializeTableEnablement(boolean isRemoteHelpDisabled) {
        HelpContentBlock currentBlock = this.remoteICPage.getHelpContentBlock();
        if (isRemoteHelpDisabled) {
            currentBlock.disableAllButtons();
        } else {
            currentBlock.restoreDefaultButtons();
        }
        currentBlock.getRemoteICviewer().getTable().setEnabled(!isRemoteHelpDisabled);
    }
}

