/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.bundle.BundlePluginBase;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.text.plugin.PluginBaseNode;
import org.eclipse.pde.internal.core.text.plugin.PluginDocumentNodeFactory;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.plugin.DependenciesPage;
import org.eclipse.pde.internal.ui.editor.plugin.DependencyPropertiesDialog;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedDependenciesAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.progress.UIJob;

public class RequiresSection
extends TableSection
implements IModelChangedListener,
IPluginModelListener,
IPropertyChangeListener {
    private static final int ADD_INDEX = 0;
    private static final int REMOVE_INDEX = 1;
    private static final int UP_INDEX = 2;
    private static final int DOWN_INDEX = 3;
    private static final int PROPERTIES_INDEX = 4;
    private TableViewer fImportViewer;
    private Vector fImports;
    private Action fOpenAction;
    private Action fAddAction;
    private Action fRemoveAction;
    private Action fPropertiesAction;
    private Action fSortAction;
    private int fImportInsertIndex;

    public RequiresSection(DependenciesPage page, Composite parent, String[] labels) {
        super((PDEFormPage)page, parent, 128, labels);
        this.getSection().setText(PDEUIMessages.RequiresSection_title);
        boolean fragment = ((IPluginModelBase)this.getPage().getModel()).isFragmentModel();
        if (fragment) {
            this.getSection().setDescription(PDEUIMessages.RequiresSection_fDesc);
        } else {
            this.getSection().setDescription(PDEUIMessages.RequiresSection_desc);
        }
        this.getTablePart().setEditable(false);
        this.resetImportInsertIndex();
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fImportViewer = tablePart.getTableViewer();
        this.fImportViewer.setContentProvider((IContentProvider)new ImportContentProvider());
        this.fImportViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        toolkit.paintBordersFor(container);
        this.makeActions();
        section.setClient((Control)container);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 250;
        gd.grabExcessVerticalSpace = true;
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        section.setLayoutData((Object)gd);
        section.setText(PDEUIMessages.RequiresSection_title);
        this.createSectionToolbar(section, toolkit);
        this.initialize();
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        this.fSortAction = new SortAction((StructuredViewer)this.fImportViewer, PDEUIMessages.RequiresSection_sortAlpha, null, null, this);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    protected void selectionChanged(IStructuredSelection sel) {
        this.getPage().getPDEEditor().setSelection((ISelection)sel);
        this.updateButtons();
    }

    private void updateButtons() {
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        EditableTablePart tablePart = this.getTablePart();
        tablePart.setButtonEnabled(0, this.isEditable());
        this.updateUpDownButtons();
        if (this.isBundle()) {
            tablePart.setButtonEnabled(4, selection.length == 1);
        }
        tablePart.setButtonEnabled(1, this.isEditable() && hasSelection);
    }

    private void updateUpDownButtons() {
        EditableTablePart tablePart = this.getTablePart();
        if (this.fSortAction.isChecked()) {
            tablePart.setButtonEnabled(2, false);
            tablePart.setButtonEnabled(3, false);
            return;
        }
        Table table = this.getTablePart().getTableViewer().getTable();
        TableItem[] selection = table.getSelection();
        boolean hasSelection = selection.length > 0;
        boolean canMove = table.getItemCount() > 1 && selection.length == 1;
        tablePart.setButtonEnabled(2, canMove && this.isEditable() && hasSelection && table.getSelectionIndex() > 0);
        tablePart.setButtonEnabled(3, canMove && hasSelection && this.isEditable() && table.getSelectionIndex() < table.getItemCount() - 1);
    }

    protected void handleDoubleClick(IStructuredSelection sel) {
        this.handleOpen((ISelection)sel);
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAdd();
                break;
            }
            case 1: {
                this.handleRemove();
                break;
            }
            case 2: {
                this.handleUp();
                break;
            }
            case 3: {
                this.handleDown();
                break;
            }
            case 4: {
                this.handleOpenProperties();
            }
        }
    }

    private void handleOpenProperties() {
        Object changeObject = ((IStructuredSelection)this.fImportViewer.getSelection()).getFirstElement();
        IPluginImport importObject = ((ImportObject)changeObject).getImport();
        DependencyPropertiesDialog dialog = new DependencyPropertiesDialog(this.isEditable(), importObject);
        dialog.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.imported_plugin_properties");
        SWTUtil.setDialogSize((Dialog)dialog, 400, -1);
        dialog.setTitle(importObject.getId());
        if (dialog.open() == 0 && this.isEditable()) {
            try {
                importObject.setOptional(dialog.isOptional());
                importObject.setReexported(dialog.isReexported());
                importObject.setVersion(dialog.getVersion());
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (!this.isEditable()) {
            return false;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            this.handleRemove();
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        return false;
    }

    protected boolean canPaste(Object targetObject, Object[] sourceObjects) {
        HashSet existingImportsSet = null;
        int i = 0;
        while (i < sourceObjects.length) {
            ImportObject importObject;
            if (!(sourceObjects[i] instanceof ImportObject)) {
                return false;
            }
            if (existingImportsSet == null) {
                existingImportsSet = PluginSelectionDialog.getExistingImports(this.getModel(), false);
            }
            if (existingImportsSet.contains((importObject = (ImportObject)sourceObjects[i]).getImport().getId())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doPaste(Object targetObject, Object[] sourceObjects) {
        IPluginModelBase model = this.getModel();
        IPluginBase pluginBase = model.getPluginBase();
        try {
            int i = 0;
            while (i < sourceObjects.length) {
                Object sourceObject = sourceObjects[i];
                if (sourceObject instanceof ImportObject) {
                    ImportObject importObject = (ImportObject)sourceObject;
                    importObject.reconnect(model);
                    pluginBase.add(importObject.getImport());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPluginModelBase getModel() {
        return (IPluginModelBase)this.getPage().getModel();
    }

    public boolean setFormInput(Object object) {
        if (object instanceof IPluginImport) {
            ImportObject iobj = new ImportObject((IPluginImport)object);
            this.fImportViewer.setSelection((ISelection)new StructuredSelection((Object)iobj), true);
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.fImportViewer.getSelection();
        manager.add((IAction)this.fAddAction);
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fOpenAction);
        }
        manager.add((IContributionItem)new Separator());
        this.getPage().contextMenuAboutToShow(manager);
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fRemoveAction);
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setContext(new ActionContext(selection));
        actionGroup.fillContextMenu(manager);
        if (((IModel)this.getPage().getModel()).getUnderlyingResource() != null) {
            manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)this.getPage().getModel(), false));
        }
        if (this.fPropertiesAction != null && !this.fImportViewer.getSelection().isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fPropertiesAction);
        }
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    protected void registerPopupMenu(MenuManager popupMenuManager) {
        IEditorSite site = (IEditorSite)this.getPage().getSite();
        site.registerContextMenu(String.valueOf(site.getId()) + ".requires", popupMenuManager, (ISelectionProvider)this.fViewerPart.getViewer(), false);
    }

    private void handleOpen(ISelection sel) {
        IPlugin plugin;
        Object obj;
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1 && (obj = ssel.getFirstElement()) instanceof ImportObject && (plugin = ((ImportObject)obj).getPlugin()) != null) {
            ManifestEditor.open(plugin, false);
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fImportViewer.getSelection();
        if (!ssel.isEmpty()) {
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            IPluginBase pluginBase = model.getPluginBase();
            IPluginImport[] imports = new IPluginImport[ssel.size()];
            int i = 0;
            Iterator iter = ssel.iterator();
            while (iter.hasNext()) {
                imports[i] = ((ImportObject)iter.next()).getImport();
                ++i;
            }
            try {
                this.removeImports(pluginBase, imports);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
            this.updateButtons();
        }
    }

    private void removeImports(IPluginBase base, IPluginImport[] imports) throws CoreException {
        if (base instanceof BundlePluginBase) {
            ((BundlePluginBase)base).remove(imports);
        } else if (base instanceof PluginBase) {
            ((PluginBase)base).remove(imports);
        } else if (base instanceof PluginBaseNode) {
            ((PluginBaseNode)base).remove(imports);
        }
    }

    private void handleAdd() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        PluginSelectionDialog dialog = new PluginSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), this.getAvailablePlugins(model), true);
        dialog.create();
        if (dialog.open() == 0) {
            Object[] models = dialog.getResult();
            IPluginImport[] imports = new IPluginImport[models.length];
            try {
                int i = 0;
                while (i < models.length) {
                    IPluginModel candidate = (IPluginModel)models[i];
                    String pluginId = candidate.getPlugin().getId();
                    IPluginImport importNode = this.createImport(model.getPluginFactory(), pluginId);
                    String version = VersionUtil.computeInitialPluginVersion((String)candidate.getPlugin().getVersion());
                    importNode.setVersion(version);
                    imports[i] = importNode;
                    ++i;
                }
                this.addImports(model.getPluginBase(), imports);
            }
            catch (CoreException coreException) {}
        }
    }

    private IPluginImport createImport(IPluginModelFactory factory, String id) {
        if (factory instanceof AbstractPluginModelBase) {
            return ((AbstractPluginModelBase)factory).createImport(id);
        }
        if (factory instanceof BundlePluginModelBase) {
            return ((BundlePluginModelBase)factory).createImport(id);
        }
        if (factory instanceof PluginDocumentNodeFactory) {
            return ((PluginDocumentNodeFactory)factory).createImport(id);
        }
        return null;
    }

    private void addImports(IPluginBase base, IPluginImport[] imports) throws CoreException {
        if (base instanceof BundlePluginBase) {
            ((BundlePluginBase)base).add(imports);
        } else if (base instanceof PluginBase) {
            ((PluginBase)base).add(imports);
        } else if (base instanceof PluginBaseNode) {
            ((PluginBaseNode)base).add(imports);
        }
    }

    private void handleUp() {
        int index = this.getTablePart().getTableViewer().getTable().getSelectionIndex();
        if (index < 1) {
            return;
        }
        this.swap(index, index - 1);
    }

    private void handleDown() {
        Table table = this.getTablePart().getTableViewer().getTable();
        int index = table.getSelectionIndex();
        if (index == table.getItemCount() - 1) {
            return;
        }
        this.swap(index, index + 1);
    }

    public void swap(int index1, int index2) {
        Table table = this.getTablePart().getTableViewer().getTable();
        IPluginImport dep1 = ((ImportObject)table.getItem(index1).getData()).getImport();
        IPluginImport dep2 = ((ImportObject)table.getItem(index2).getData()).getImport();
        try {
            IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
            IPluginBase pluginBase = model.getPluginBase();
            pluginBase.swap(dep1, dep2);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private IPluginModelBase[] getAvailablePlugins(IPluginModelBase model) {
        IPluginModelBase[] plugins = PluginRegistry.getActiveModels((boolean)false);
        HashSet existingImports = PluginSelectionDialog.getExistingImports(model, false);
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < plugins.length) {
            if (!existingImports.contains(plugins[i].getPluginBase().getId())) {
                result.add(plugins[i]);
            }
            ++i;
        }
        if (!existingImports.contains("system.bundle")) {
            this.addSystemBundle(result);
        }
        return result.toArray(new IPluginModelBase[result.size()]);
    }

    private void addSystemBundle(List list) {
        try {
            ExternalPluginModel model = new ExternalPluginModel();
            IPluginModelBase osgi = PluginRegistry.findModel((String)"system.bundle");
            if (osgi == null) {
                return;
            }
            model.setInstallLocation(osgi.getInstallLocation());
            String pluginInfo = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><plugin id=\"system.bundle\" name=\"System Bundle\"></plugin>";
            BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(pluginInfo.getBytes()));
            model.load((InputStream)is, false);
            list.add(model);
        }
        catch (CoreException coreException) {}
    }

    public void initialize() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model == null) {
            return;
        }
        this.fImportViewer.setInput((Object)model.getPluginBase());
        this.updateButtons();
        model.addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        this.fAddAction.setEnabled(model.isEditable());
        this.fRemoveAction.setEnabled(model.isEditable());
    }

    private void makeActions() {
        this.fAddAction = new Action(PDEUIMessages.RequiresSection_add){

            public void run() {
                RequiresSection.this.handleAdd();
            }
        };
        this.fOpenAction = new Action(PDEUIMessages.RequiresSection_open){

            public void run() {
                RequiresSection.this.handleOpen(RequiresSection.this.fImportViewer.getSelection());
            }
        };
        this.fRemoveAction = new Action(PDEUIMessages.RequiresSection_delete){

            public void run() {
                RequiresSection.this.handleRemove();
            }
        };
        if (this.isBundle()) {
            this.fPropertiesAction = new Action(PDEUIMessages.RequiresSection_properties){

                public void run() {
                    RequiresSection.this.handleOpenProperties();
                }
            };
        }
    }

    public void refresh() {
        this.fImports = null;
        this.fImportViewer.refresh();
        super.refresh();
    }

    public void modelChanged(final IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.markStale();
            return;
        }
        UIJob job = new UIJob("Update required bundles"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (event.getChangedProperty() == "import_order") {
                    RequiresSection.this.refresh();
                    RequiresSection.this.updateButtons();
                    return Status.OK_STATUS;
                }
                Object[] changedObjects = event.getChangedObjects();
                if (changedObjects[0] instanceof IPluginImport) {
                    int index = 0;
                    int i = 0;
                    while (i < changedObjects.length) {
                        ImportObject iobj;
                        Object changeObject = changedObjects[i];
                        IPluginImport iimport = (IPluginImport)changeObject;
                        if (event.getChangeType() == 1) {
                            iobj = new ImportObject(iimport);
                            if (RequiresSection.this.fImports == null) {
                                RequiresSection.this.createImportObjects();
                            } else {
                                int insertIndex = RequiresSection.this.getImportInsertIndex();
                                if (insertIndex < 0) {
                                    RequiresSection.this.fImports.add(iobj);
                                } else {
                                    RequiresSection.this.fImports.add(insertIndex, iobj);
                                }
                            }
                        } else {
                            iobj = RequiresSection.this.findImportObject(iimport);
                            if (iobj != null) {
                                if (event.getChangeType() == 2) {
                                    if (RequiresSection.this.fImports == null) {
                                        RequiresSection.this.createImportObjects();
                                    } else {
                                        RequiresSection.this.fImports.remove(iobj);
                                    }
                                    Table table = RequiresSection.this.fImportViewer.getTable();
                                    index = table.getSelectionIndex();
                                    RequiresSection.this.fImportViewer.remove((Object)iobj);
                                } else {
                                    RequiresSection.this.fImportViewer.update((Object)iobj, null);
                                }
                            }
                        }
                        ++i;
                    }
                    if (event.getChangeType() == 1) {
                        if (changedObjects.length > 0) {
                            RequiresSection.this.fImportViewer.refresh();
                            IPluginImport lastImport = (IPluginImport)changedObjects[changedObjects.length - 1];
                            ImportObject lastImportObject = RequiresSection.this.findImportObject(lastImport);
                            if (lastImportObject != null) {
                                RequiresSection.this.fImportViewer.setSelection((ISelection)new StructuredSelection((Object)lastImportObject));
                            }
                            RequiresSection.this.fImportViewer.getTable().setFocus();
                        }
                    } else if (event.getChangeType() == 2) {
                        Table table;
                        table.setSelection(index < (table = RequiresSection.this.fImportViewer.getTable()).getItemCount() ? index : table.getItemCount() - 1);
                    }
                } else {
                    RequiresSection.this.fImportViewer.update(((IStructuredSelection)RequiresSection.this.fImportViewer.getSelection()).toArray(), null);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void modelsChanged(PluginModelDelta delta) {
        this.fImports = null;
        final Control control = this.fImportViewer.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        RequiresSection.this.fImportViewer.refresh();
                    }
                }
            });
        }
    }

    private ImportObject findImportObject(IPluginImport iimport) {
        if (this.fImports == null) {
            return null;
        }
        int i = 0;
        while (i < this.fImports.size()) {
            ImportObject iobj = (ImportObject)this.fImports.get(i);
            if (iobj.getImport().equals(iimport)) {
                return iobj;
            }
            ++i;
        }
        return null;
    }

    private void createImportObjects() {
        this.fImports = new Vector();
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        IPluginImport[] iimports = model.getPluginBase().getImports();
        int i = 0;
        while (i < iimports.length) {
            IPluginImport iimport = iimports[i];
            this.fImports.add(new ImportObject(iimport));
            ++i;
        }
    }

    public void setFocus() {
        if (this.fImportViewer != null) {
            this.fImportViewer.getTable().setFocus();
        }
    }

    private boolean isBundle() {
        return this.getPage().getPDEEditor().getContextManager().findContext("bundle-context") != null;
    }

    protected boolean createCount() {
        return true;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fSortAction.equals(event.getSource()) && "result".equals(event.getProperty())) {
            this.updateUpDownButtons();
        }
    }

    protected boolean isDragAndDropEnabled() {
        return true;
    }

    public boolean canDragMove(Object[] sourceObjects) {
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return false;
        }
        return !this.isTreeViewerSorted();
    }

    private boolean validateDragMoveSanity(Object[] sourceObjects) {
        if (sourceObjects == null) {
            return false;
        }
        if (sourceObjects.length != 1) {
            return false;
        }
        return sourceObjects[0] instanceof ImportObject;
    }

    private boolean validateDropMoveSanity(Object targetObject, Object[] sourceObjects) {
        if (!(targetObject instanceof ImportObject)) {
            return false;
        }
        return this.validateDragMoveSanity(sourceObjects);
    }

    private boolean validateDropMoveModel(ImportObject sourceImportObject, ImportObject targetImportObject) {
        IPluginModelBase targetModel;
        IPluginModelBase sourceModel = sourceImportObject.getImport().getPluginModel();
        if (!sourceModel.equals(targetModel = targetImportObject.getImport().getPluginModel())) {
            return false;
        }
        return this.getModel().getPluginBase() instanceof BundlePluginBase;
    }

    public boolean canDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            return false;
        }
        ImportObject sourceImportObject = (ImportObject)sourceObjects[0];
        ImportObject targetImportObject = (ImportObject)targetObject;
        IPluginImport sourcePluginImport = sourceImportObject.getImport();
        IPluginImport targetPluginImport = targetImportObject.getImport();
        if (!this.validateDropMoveModel(sourceImportObject, targetImportObject)) {
            return false;
        }
        BundlePluginBase bundlePluginBase = (BundlePluginBase)this.getModel().getPluginBase();
        if (targetLocation == 1) {
            IPluginImport previousImport = bundlePluginBase.getPreviousImport(targetPluginImport);
            return !sourcePluginImport.equals(previousImport);
        }
        if (targetLocation == 2) {
            IPluginImport nextImport = bundlePluginBase.getNextImport(targetPluginImport);
            return !sourcePluginImport.equals(nextImport);
        }
        if (targetLocation == 3) {
            return false;
        }
        return false;
    }

    public void doDropMove(Object targetObject, Object[] sourceObjects, int targetLocation) {
        if (!this.validateDropMoveSanity(targetObject, sourceObjects)) {
            Display.getDefault().beep();
            return;
        }
        ImportObject sourceImportObject = (ImportObject)sourceObjects[0];
        ImportObject targetImportObject = (ImportObject)targetObject;
        IPluginImport sourcePluginImport = sourceImportObject.getImport();
        IPluginImport targetPluginImport = targetImportObject.getImport();
        if (targetLocation == 1 || targetLocation == 2) {
            this.doDropMove(sourceImportObject, sourcePluginImport, targetPluginImport, targetLocation);
        }
    }

    private void doDropMove(ImportObject sourceImportObject, IPluginImport sourcePluginImport, IPluginImport targetPluginImport, int targetLocation) {
        this.doDragRemove();
        BundlePluginBase bundlePluginBase = (BundlePluginBase)this.getModel().getPluginBase();
        int index = bundlePluginBase.getIndexOf(targetPluginImport);
        if (index == -1) {
            return;
        }
        int targetIndex = index;
        if (targetLocation == 2) {
            ++targetIndex;
        }
        sourceImportObject.reconnect(this.getModel());
        this.setImportInsertIndex(targetIndex);
        try {
            bundlePluginBase.add(sourcePluginImport, targetIndex);
        }
        catch (CoreException coreException) {}
        this.resetImportInsertIndex();
    }

    private void resetImportInsertIndex() {
        this.fImportInsertIndex = -1;
    }

    private void setImportInsertIndex(int index) {
        this.fImportInsertIndex = index;
    }

    private int getImportInsertIndex() {
        return this.fImportInsertIndex;
    }

    private void doDragRemove() {
        BundlePluginBase bundlePluginBase = (BundlePluginBase)this.getModel().getPluginBase();
        Object[] sourceObjects = this.getDragSourceObjects();
        if (!this.validateDragMoveSanity(sourceObjects)) {
            return;
        }
        IPluginImport sourcePluginImport = ((ImportObject)sourceObjects[0]).getImport();
        try {
            bundlePluginBase.remove(sourcePluginImport);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private boolean isTreeViewerSorted() {
        if (this.fSortAction == null) {
            return false;
        }
        return this.fSortAction.isChecked();
    }

    class ImportContentProvider
    extends DefaultTableProvider {
        ImportContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (RequiresSection.this.fImports == null) {
                RequiresSection.this.createImportObjects();
            }
            return RequiresSection.this.fImports.toArray();
        }
    }
}

