/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.impl.CommandsFactoryImpl;
import org.eclipse.ui.internal.contexts.ContextPersistence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextToModelProcessor {
    private Map<String, MBindingContext> contexts = new HashMap<String, MBindingContext>();

    @Execute
    void process(MApplication application) {
        this.gatherContexts(application.getRootContext());
        ContextManager contextManager = new ContextManager();
        ContextPersistence cp = new ContextPersistence(contextManager);
        cp.reRead();
        this.generateContexts(application, contextManager);
        cp.dispose();
    }

    private void generateContexts(MApplication application, ContextManager contextManager) {
        MBindingContext contextModel;
        Context ctx;
        Context[] contextArray = contextManager.getDefinedContexts();
        int n = contextArray.length;
        int n2 = 0;
        while (n2 < n) {
            ctx = contextArray[n2];
            try {
                contextModel = this.contexts.get(ctx.getId());
                if (contextModel == null) {
                    contextModel = CommandsFactoryImpl.eINSTANCE.createBindingContext();
                    this.contexts.put(ctx.getId(), contextModel);
                }
                contextModel.setElementId(ctx.getId());
                contextModel.setName(ctx.getName());
                contextModel.setDescription(ctx.getDescription());
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        contextArray = contextManager.getDefinedContexts();
        n = contextArray.length;
        n2 = 0;
        while (n2 < n) {
            ctx = contextArray[n2];
            try {
                contextModel = this.contexts.get(ctx.getId());
                String parentId = ctx.getParentId();
                if (parentId == null) {
                    if (!application.getRootContext().contains(contextModel)) {
                        application.getRootContext().add(contextModel);
                    }
                } else {
                    MBindingContext parentContextModel = this.contexts.get(parentId);
                    if (parentContextModel == null) {
                        System.err.println("Could not find parent " + parentId + " for child " + ctx.getId());
                    } else if (!parentContextModel.getChildren().contains(contextModel)) {
                        parentContextModel.getChildren().add(contextModel);
                    }
                }
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private void gatherContexts(List<MBindingContext> contextList) {
        for (MBindingContext ctx : contextList) {
            this.gatherContexts(ctx);
        }
    }

    private void gatherContexts(MBindingContext ctx) {
        if (ctx == null) {
            return;
        }
        this.contexts.put(ctx.getElementId(), ctx);
        this.gatherContexts(ctx.getChildren());
    }
}

