/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.actions.OpenProjectAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.CloseResourceAction;
import org.eclipse.ui.actions.CloseUnrelatedProjectsAction;
import org.eclipse.ui.ide.IDEActionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectActionGroup
extends ActionGroup {
    private ISelectionProvider fSelectionProvider;
    private OpenProjectAction fOpenAction;
    private boolean fEnableOpenInContextMenu = true;
    private CloseResourceAction fCloseAction;
    private CloseResourceAction fCloseUnrelatedAction;
    private ISelectionChangedListener fSelectionChangedListener;
    private int CLOSED_PROJECTS_SELECTED = 1;
    private int NON_PROJECT_SELECTED = 2;

    public ProjectActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), part.getSite().getSelectionProvider());
    }

    public ProjectActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        this.fSelectionProvider = selectionProvider;
        ISelection selection = selectionProvider.getSelection();
        this.fCloseAction = new CloseResourceAction((IShellProvider)site);
        this.fCloseAction.setActionDefinitionId("org.eclipse.ui.project.closeProject");
        this.fCloseUnrelatedAction = new CloseUnrelatedProjectsAction((IShellProvider)site);
        this.fCloseUnrelatedAction.setActionDefinitionId("org.eclipse.ui.project.closeUnrelatedProjects");
        this.fOpenAction = new OpenProjectAction(site);
        this.fOpenAction.setActionDefinitionId("org.eclipse.ui.project.openProject");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            this.fOpenAction.selectionChanged(s);
            this.fCloseAction.selectionChanged(s);
            this.fCloseUnrelatedAction.selectionChanged(s);
        }
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection s = event.getSelection();
                if (s instanceof IStructuredSelection) {
                    ProjectActionGroup.this.performSelectionChanged((IStructuredSelection)s);
                }
            }
        };
        selectionProvider.addSelectionChangedListener(this.fSelectionChangedListener);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.addResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        workspace.addResourceChangeListener((IResourceChangeListener)this.fCloseUnrelatedAction);
    }

    protected void performSelectionChanged(IStructuredSelection structuredSelection) {
        Object[] array = structuredSelection.toArray();
        ArrayList<IProject> openProjects = new ArrayList<IProject>();
        int selectionStatus = this.evaluateSelection(array, openProjects);
        StructuredSelection sel = new StructuredSelection(openProjects);
        this.fOpenAction.setEnabled(this.hasClosedProjectsInWorkspace());
        this.fEnableOpenInContextMenu = (selectionStatus & this.CLOSED_PROJECTS_SELECTED) != 0 || selectionStatus == 0 && array.length == 0 && this.hasClosedProjectsInWorkspace();
        this.fCloseAction.selectionChanged((IStructuredSelection)sel);
        this.fCloseUnrelatedAction.selectionChanged((IStructuredSelection)sel);
    }

    private int evaluateSelection(Object[] array, List<IProject> allOpenProjects) {
        int status = 0;
        int i = 0;
        while (i < array.length) {
            Object curr = array[i];
            if (curr instanceof IJavaProject) {
                curr = ((IJavaProject)curr).getProject();
            }
            if (curr instanceof IProject) {
                IProject project = (IProject)curr;
                if (project.isOpen()) {
                    allOpenProjects.add(project);
                } else {
                    status |= this.CLOSED_PROJECTS_SELECTED;
                }
            } else if (curr instanceof IWorkingSet) {
                int res = this.evaluateSelection(((IWorkingSet)curr).getElements(), allOpenProjects);
                status |= res;
            } else {
                status |= this.NON_PROJECT_SELECTED;
            }
            ++i;
        }
        return status;
    }

    private boolean hasClosedProjectsInWorkspace() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].isOpen()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_PROJECT.getId(), (IAction)this.fCloseAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.CLOSE_UNRELATED_PROJECTS.getId(), (IAction)this.fCloseUnrelatedAction);
        actionBars.setGlobalActionHandler(IDEActionFactory.OPEN_PROJECT.getId(), (IAction)this.fOpenAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (this.fOpenAction.isEnabled() && this.fEnableOpenInContextMenu) {
            menu.appendToGroup("group.build", (IAction)this.fOpenAction);
        }
        if (this.fCloseAction.isEnabled()) {
            menu.appendToGroup("group.build", (IAction)this.fCloseAction);
        }
        if (this.fCloseUnrelatedAction.isEnabled() && this.areOnlyProjectsSelected(this.fCloseUnrelatedAction.getStructuredSelection())) {
            menu.appendToGroup("group.build", (IAction)this.fCloseUnrelatedAction);
        }
    }

    public OpenProjectAction getOpenProjectAction() {
        return this.fOpenAction;
    }

    private boolean areOnlyProjectsSelected(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object obj : selection) {
            if (!(obj instanceof IAdaptable) || ((IAdaptable)obj).getAdapter(IProject.class) != null) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        this.fSelectionProvider.removeSelectionChangedListener(this.fSelectionChangedListener);
        this.fSelectionProvider = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fOpenAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseAction);
        workspace.removeResourceChangeListener((IResourceChangeListener)this.fCloseUnrelatedAction);
        super.dispose();
    }
}

