/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.HIThemeTabDrawInfo;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.TabFolderDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class TabItemDrawData
extends DrawData {
    public TabFolderDrawData parent;
    public int position;

    public TabItemDrawData() {
        this.state = new int[1];
    }

    Rectangle computeTrim(Theme theme, GC gc) {
        int[] metric = new int[1];
        OS.GetThemeMetric(11, metric);
        int x = this.clientArea.x - metric[0];
        int y = this.clientArea.y - metric[0];
        int width = this.clientArea.width + metric[0] * 2;
        int height = this.clientArea.height + metric[0] * 2;
        return new Rectangle(x, y, width, height);
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        CGRect rect = new CGRect();
        rect.x = bounds.x;
        rect.y = bounds.y;
        rect.width = bounds.width;
        rect.height = bounds.height;
        CGRect labelRect = this.clientArea != null ? new CGRect() : null;
        HIThemeTabDrawInfo info = this.getInfo();
        OS.HIThemeDrawTab(rect, info, gc.handle, 0, labelRect);
        if (this.clientArea != null) {
            this.clientArea.x = (int)labelRect.x;
            this.clientArea.y = (int)labelRect.y;
            this.clientArea.width = (int)labelRect.width;
            this.clientArea.height = (int)labelRect.height;
        }
    }

    HIThemeTabDrawInfo getInfo() {
        int state = this.state[0];
        HIThemeTabDrawInfo info = new HIThemeTabDrawInfo();
        info.version = 1;
        info.style = (state & 0x20) == 0 ? ((state & 0x10) != 0 ? ((state & 2) != 0 ? (short)3 : ((state & 8) != 0 ? (short)1 : 0)) : ((state & 2) != 0 ? (short)4 : (short)2)) : ((state & 0x10) != 0 ? (short)6 : (short)5);
        info.direction = 0;
        if ((this.parent.style & 0x400) != 0) {
            info.direction = 1;
        }
        if ((this.parent.style & 0x80) != 0) {
            info.direction = 0;
        }
        info.size = 0;
        if ((state & 4) != 0) {
            info.adornment = 4;
        }
        info.adornment |= 0x10;
        info.position = 1;
        if ((this.position & 0x20000) != 0 && (this.position & 0x4000) != 0) {
            info.position = 3;
        } else if ((this.position & 0x4000) != 0) {
            info.position = 0;
            info.adornment |= 0x10;
        } else if ((this.position & 0x20000) != 0) {
            info.position = 2;
        }
        return info;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        if (!bounds.contains(position)) {
            return -1;
        }
        return 0;
    }
}

