/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String URL = "url ";
    static final int URL_ID = URLTransfer.registerType("url ");
    static final String URLN = "urln";
    static final int URLN_ID = URLTransfer.registerType("urln");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -1;
        String url = (String)object;
        int count = url.length();
        char[] chars = new char[count];
        url.getChars(0, count, chars, 0);
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, count);
        if (cfstring == 0) {
            return;
        }
        try {
            CFRange range = new CFRange();
            range.length = chars.length;
            int encoding = 0x8000100;
            int[] size = new int[1];
            int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size);
            if (numChars == 0 || size[0] == 0) {
                return;
            }
            byte[] buffer = new byte[size[0]];
            numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
            if (numChars == 0) {
                return;
            }
            transferData.data = new byte[][]{buffer};
            transferData.result = 0;
        }
        finally {
            OS.CFRelease(cfstring);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0) {
            return null;
        }
        byte[] buffer = transferData.data[0];
        int encoding = 0x8000100;
        int cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, true);
        if (cfstring == 0) {
            return null;
        }
        char[] unescapedChars = new char[]{'%'};
        int unescapedStr = OS.CFStringCreateWithCharacters(0, unescapedChars, unescapedChars.length);
        int str = OS.CFURLCreateStringByReplacingPercentEscapes(0, cfstring, unescapedStr);
        OS.CFRelease(unescapedStr);
        OS.CFRelease(cfstring);
        if (str == 0) {
            return null;
        }
        try {
            int length = OS.CFStringGetLength(str);
            if (length == 0) {
                return null;
            }
            char[] chars = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(str, range, chars);
            String string = new String(chars);
            return string;
        }
        finally {
            OS.CFRelease(str);
        }
    }

    protected int[] getTypeIds() {
        return new int[]{URL_ID, URLN_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URL, URLN};
    }

    boolean checkURL(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

