/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TargetDefinitionExportWizardPage
extends WizardPage {
    private static final String PAGE_ID = "org.eclipse.pde.target.exportPage";
    private Button fBrowseButton = null;
    private Combo fDestinationCombo = null;
    private Button fClearDestinationButton = null;
    private ITargetDefinition fTarget = null;
    private static final String SETTINGS_LOCATION_1 = "location1";
    private static final String SETTINGS_LOCATION_2 = "location2";
    private static final String SETTINGS_LOCATION_3 = "location3";
    private static final String SETTINGS_CLEAR = "clear";

    protected TargetDefinitionExportWizardPage(ITargetDefinition target) {
        super(PAGE_ID);
        this.fTarget = target;
        this.setPageComplete(false);
        this.setTitle(PDEUIMessages.ExportActiveTargetDefinition);
        this.setMessage(PDEUIMessages.ExportActiveTargetDefinition_message);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.createExportDirectoryControl(container);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.target_export_wizard");
    }

    private void createExportDirectoryControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(768));
        new Label(parent, 0).setText(PDEUIMessages.ExportTargetCurrentTarget);
        Label l = new Label(parent, 0);
        l.setText(this.fTarget.getName());
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        new Label(parent, 0).setText(PDEUIMessages.ExportTargetChooseFolder);
        this.fDestinationCombo = SWTFactory.createCombo(parent, 2048, 1, null);
        this.fDestinationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TargetDefinitionExportWizardPage.this.controlChanged();
            }
        });
        this.fBrowseButton = new Button(parent, 8);
        this.fBrowseButton.setText(PDEUIMessages.ExportTargetBrowse);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(TargetDefinitionExportWizardPage.this.getShell());
                dialog.setText(PDEUIMessages.ExportTargetSelectDestination);
                dialog.setMessage(PDEUIMessages.ExportTargetSpecifyDestination);
                String dir = TargetDefinitionExportWizardPage.this.fDestinationCombo.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TargetDefinitionExportWizardPage.this.fDestinationCombo.setText(dir);
                TargetDefinitionExportWizardPage.this.controlChanged();
            }
        });
        this.fClearDestinationButton = new Button(parent, 32);
        this.fClearDestinationButton.setText(PDEUIMessages.ExportTargetClearDestination);
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 15;
        this.fClearDestinationButton.setLayoutData((Object)gd);
        this.initSettings();
    }

    public String getDestinationDirectory() {
        return this.fDestinationCombo.getText();
    }

    public boolean isClearDestinationDirectory() {
        return this.fClearDestinationButton.getSelection();
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        this.setMessage(null);
        if (this.fDestinationCombo.getText().equals("")) {
            this.setErrorMessage(PDEUIMessages.ExportTargetError_ChooseDestination);
            return false;
        }
        if (!this.isValidLocation(this.fDestinationCombo.getText().trim())) {
            this.setErrorMessage(PDEUIMessages.ExportTargetError_validPath);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(SETTINGS_CLEAR, this.fClearDestinationButton.getSelection());
            String newLocation = this.fDestinationCombo.getText().trim();
            if (newLocation.charAt(newLocation.length() - 1) == File.separatorChar) {
                newLocation = newLocation.substring(0, newLocation.length() - 1);
            }
            String[] items = this.fDestinationCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(newLocation)) {
                    return;
                }
                ++i;
            }
            String location = settings.get(SETTINGS_LOCATION_2);
            if (location != null) {
                settings.put(SETTINGS_LOCATION_3, location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_1)) != null) {
                settings.put(SETTINGS_LOCATION_2, location);
            }
            settings.put(SETTINGS_LOCATION_1, newLocation);
        }
    }

    private void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fClearDestinationButton.setSelection(settings.getBoolean(SETTINGS_CLEAR));
            String location = settings.get(SETTINGS_LOCATION_1);
            if (location != null) {
                this.fDestinationCombo.add(location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_2)) != null) {
                this.fDestinationCombo.add(location);
            }
            if ((location = settings.get(SETTINGS_LOCATION_3)) != null) {
                this.fDestinationCombo.add(location);
            }
            if (this.fDestinationCombo.getItemCount() > 0) {
                this.fDestinationCombo.setText(this.fDestinationCombo.getItem(0));
            }
        }
    }

    protected boolean isValidLocation(String location) {
        try {
            String destinationPath = new File(location).getCanonicalPath();
            return destinationPath != null && destinationPath.length() != 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

