/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.GatherUnusedDependenciesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.ShowResultsAction;
import org.eclipse.swt.widgets.Display;

public class UnusedDependenciesJob
extends Job {
    private IPluginModelBase fModel;
    private boolean fReadOnly;

    public UnusedDependenciesJob(String name, IPluginModelBase model, boolean readOnly) {
        super(name);
        this.fModel = model;
        this.fReadOnly = readOnly;
    }

    protected IStatus run(IProgressMonitor monitor) {
        block7: {
            try {
                GatherUnusedDependenciesOperation udo = new GatherUnusedDependenciesOperation(this.fModel);
                udo.run(monitor);
                this.showResults(udo.getList().toArray());
            }
            catch (InvocationTargetException invocationTargetException) {
                monitor.done();
                break block7;
            }
            catch (InterruptedException interruptedException) {
                try {
                    break block7;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        return new Status(0, PDEPlugin.getPluginId(), 0, PDEUIMessages.UnusedDependenciesJob_viewResults, null);
    }

    private Action getShowResultsAction(Object[] unused) {
        return new ShowResultsAction(this.fModel, unused, this.fReadOnly);
    }

    protected void showResults(final Object[] unused) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                UnusedDependenciesJob.this.getShowResultsAction(unused).run();
            }
        });
    }
}

