/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsProcessor;
import org.eclipse.pde.internal.ui.nls.ExternalizeStringsWizard;
import org.eclipse.pde.internal.ui.nls.GetNonExternalizedStringsOperation;
import org.eclipse.pde.internal.ui.nls.ModelChangeTable;
import org.eclipse.pde.internal.ui.refactoring.PDERefactor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class GetNonExternalizedStringsAction
implements IWorkbenchWindowActionDelegate {
    private ISelection fSelection;
    private boolean fExternalizeSelectedPluginsOnly = false;
    private boolean fSkipMessageDialog = false;

    public void run(IAction action) {
        block26: {
            block28: {
                GetNonExternalizedStringsOperation runnable = new GetNonExternalizedStringsOperation(this.fSelection, this.fExternalizeSelectedPluginsOnly);
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)runnable);
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (runnable.wasCanceled()) {
                        return;
                    }
                    ModelChangeTable changeTable = runnable.getChangeTable();
                    if (!changeTable.isEmpty()) {
                        ExternalizeStringsProcessor processor = new ExternalizeStringsProcessor();
                        PDERefactor refactor = new PDERefactor(processor);
                        ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(changeTable, refactor);
                        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                        try {
                            op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (!this.fSkipMessageDialog) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedTitle, (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedMessage);
                    }
                    break block26;
                }
                catch (InterruptedException interruptedException) {
                    block27: {
                        ExternalizeStringsWizard wizard;
                        try {
                            if (runnable.wasCanceled()) {
                                return;
                            }
                            ModelChangeTable changeTable = runnable.getChangeTable();
                            if (changeTable.isEmpty()) break block27;
                            ExternalizeStringsProcessor processor = new ExternalizeStringsProcessor();
                            PDERefactor refactor = new PDERefactor(processor);
                            wizard = new ExternalizeStringsWizard(changeTable, refactor);
                        }
                        catch (Throwable throwable) {
                            if (runnable.wasCanceled()) {
                                return;
                            }
                            ModelChangeTable changeTable = runnable.getChangeTable();
                            if (!changeTable.isEmpty()) {
                                ExternalizeStringsProcessor processor = new ExternalizeStringsProcessor();
                                PDERefactor refactor = new PDERefactor(processor);
                                ExternalizeStringsWizard wizard2 = new ExternalizeStringsWizard(changeTable, refactor);
                                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard2);
                                try {
                                    op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                                }
                                catch (InterruptedException interruptedException2) {}
                            } else if (!this.fSkipMessageDialog) {
                                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedTitle, (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedMessage);
                            }
                            throw throwable;
                        }
                        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                        try {
                            op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                        }
                        catch (InterruptedException interruptedException3) {}
                        break block26;
                    }
                    if (!this.fSkipMessageDialog) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedTitle, (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedMessage);
                    }
                    break block26;
                }
                if (runnable.wasCanceled()) {
                    return;
                }
                ModelChangeTable changeTable = runnable.getChangeTable();
                if (changeTable.isEmpty()) break block28;
                ExternalizeStringsProcessor processor = new ExternalizeStringsProcessor();
                PDERefactor refactor = new PDERefactor(processor);
                ExternalizeStringsWizard wizard = new ExternalizeStringsWizard(changeTable, refactor);
                RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                try {
                    op.run(PDEPlugin.getActiveWorkbenchShell(), "");
                }
                catch (InterruptedException interruptedException) {}
                break block26;
            }
            if (!this.fSkipMessageDialog) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedTitle, (String)PDEUIMessages.GetNonExternalizedStringsAction_allExternalizedMessage);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void setExternalizeSelectedPluginsOnly(boolean externalizeSelectedPluginsOnly) {
        this.fExternalizeSelectedPluginsOnly = externalizeSelectedPluginsOnly;
    }

    public boolean isExternalizeSelectedPluginsOnly() {
        return this.fExternalizeSelectedPluginsOnly;
    }

    public void setSkipMessageDialog(boolean skipMessageDialog) {
        this.fSkipMessageDialog = skipMessageDialog;
    }

    public boolean isSkipMessageDialog() {
        return this.fSkipMessageDialog;
    }
}

