/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.util.HeaderMap;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeCompletionProposal;
import org.eclipse.pde.internal.ui.editor.contentassist.TypePackageCompletionProcessor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.util.ImageOverlayIcon;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class ManifestContentAssistProcessor
extends TypePackageCompletionProcessor
implements ICompletionListener {
    protected PDESourcePage fSourcePage;
    private IJavaProject fJP;
    private static final String[] fHeader = new String[]{"Bundle-ActivationPolicy", "Bundle-Activator", "Bundle-Category", "Bundle-ClassPath", "Bundle-ContactAddress", "Bundle-Copyright", "Bundle-Description", "Bundle-DocURL", "Bundle-Localization", "Bundle-ManifestVersion", "Bundle-Name", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "Bundle-SymbolicName", "Bundle-UpdateLocation", "Bundle-Vendor", "Bundle-Version", "DynamicImport-Package", "Eclipse-BuddyPolicy", "Eclipse-BundleShape", "Eclipse-GenericCapabilty", "Eclipse-GenericRequire", "Eclipse-LazyStart", "Eclipse-PlatformFilter", "Eclipse-RegisterBuddy", "Export-Package", "Export-Service", "Fragment-Host", "Import-Package", "Import-Service", "Require-Bundle"};
    private static final String BAUMAN = "Brian Bauman";
    private static final String ANISZCZYK = "Chris Aniszczyk";
    private static final String LASOCKI_BICZYSKO = "Janek Lasocki-Biczysko";
    private static final String PAWLOWSKI = "Mike Pawlowski";
    private static final String MELHEM = "Wassim Melhem";
    private static final String WINDATT = "Curtis Windatt";
    private static final String[] fNames = new String[]{"Brian Bauman", "Chris Aniszczyk", "Janek Lasocki-Biczysko", "Mike Pawlowski", "Wassim Melhem", "Curtis Windatt"};
    protected static final short F_TYPE_HEADER = 0;
    protected static final short F_TYPE_PKG = 1;
    protected static final short F_TYPE_BUNDLE = 2;
    protected static final short F_TYPE_CLASS = 3;
    protected static final short F_TYPE_DIRECTIVE = 4;
    protected static final short F_TYPE_ATTRIBUTE = 5;
    protected static final short F_TYPE_VALUE = 6;
    protected static final short F_TYPE_EXEC_ENV = 7;
    protected static final short F_TOTAL_TYPES = 8;
    private final Image[] fImages = new Image[8];
    private static final String[] fExecEnvs;
    Map fHeaders;

    static {
        IExecutionEnvironment[] envs = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        fExecEnvs = new String[envs.length];
        int i = 0;
        while (i < envs.length) {
            ManifestContentAssistProcessor.fExecEnvs[i] = envs[i].getId();
            ++i;
        }
        Arrays.sort(fExecEnvs, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
        });
    }

    public ManifestContentAssistProcessor(PDESourcePage sourcePage) {
        this.fSourcePage = sourcePage;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        IDocument doc = this.fSourcePage.getDocumentProvider().getDocument((Object)this.fSourcePage.getInputContext().getInput());
        if (this.fHeaders == null) {
            this.parseDocument(doc);
        }
        try {
            int lineNum = doc.getLineOfOffset(offset);
            int lineStart = doc.getLineOffset(lineNum);
            return this.computeCompletionProposals(doc, lineStart, offset);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected final void parseDocument(IDocument doc) {
        this.fHeaders = new HeaderMap();
        int numLines = doc.getNumberOfLines();
        int offset = 0;
        int i = 1;
        while (i < numLines) {
            block9: {
                try {
                    IRegion nextLine = doc.getLineInformation(i);
                    if (!this.containsNewHeader(doc.get(nextLine.getOffset(), nextLine.getLength())) && i != numLines - 1) break block9;
                    String value = doc.get(offset, nextLine.getOffset() - offset - 1).trim();
                    int index = value.indexOf(58);
                    String header = index == -1 ? value : value.substring(0, index);
                    try {
                        if (value.endsWith(",")) {
                            value = value.substring(0, value.length() - 1);
                        }
                        ManifestElement[] elems = ManifestElement.parseHeader((String)header, (String)value.substring(index + 1));
                        if (this.shouldStoreSet(header)) {
                            HashSet<String> set = new HashSet<String>(1 * elems.length + 1);
                            int j = 0;
                            while (j < elems.length) {
                                set.add(elems[j].getValue());
                                ++j;
                            }
                            this.fHeaders.put(header, set);
                        } else {
                            this.fHeaders.put(header, elems);
                        }
                    }
                    catch (BundleException bundleException) {}
                    offset = nextLine.getOffset();
                }
                catch (BadLocationException badLocationException) {}
            }
            ++i;
        }
    }

    private boolean containsNewHeader(String text) {
        int length = text.length();
        if (length == 0) {
            return true;
        }
        int index = text.indexOf(58);
        while (index != -1) {
            if (index == length - 1 || text.charAt(index + 1) != '=') {
                return true;
            }
            index = text.indexOf(58, index + 1);
        }
        return false;
    }

    protected final boolean shouldStoreSet(String header) {
        return header.equalsIgnoreCase("Import-Package") || header.equalsIgnoreCase("Export-Package") || header.equalsIgnoreCase("Require-Bundle") || header.equalsIgnoreCase("Bundle-RequiredExecutionEnvironment");
    }

    protected ICompletionProposal[] computeCompletionProposals(IDocument doc, int startOffset, int offset) {
        try {
            if (!this.isHeader(doc, startOffset, offset)) {
                return this.computeValue(doc, startOffset, offset);
            }
            return this.computeHeader(doc.get(startOffset, offset - startOffset), startOffset, offset);
        }
        catch (BadLocationException badLocationException) {
            return new ICompletionProposal[0];
        }
    }

    protected final boolean isHeader(IDocument doc, int startOffset, int offset) throws BadLocationException {
        String value = doc.get(startOffset, offset - startOffset);
        if (value.indexOf(58) != -1) {
            return false;
        }
        --startOffset;
        while (startOffset >= 0) {
            char ch = doc.getChar(startOffset);
            if (!Character.isWhitespace(ch)) {
                return ch != ',' && ch != ':' && ch != ';';
            }
            --startOffset;
        }
        return true;
    }

    protected ICompletionProposal[] computeHeader(String currentValue, int startOffset, int offset) {
        ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
        int i = 0;
        while (i < fHeader.length) {
            if (fHeader[i].regionMatches(true, 0, currentValue, 0, currentValue.length()) && this.fHeaders.get(fHeader[i]) == null) {
                TypeCompletionProposal proposal = new TypeCompletionProposal(String.valueOf(fHeader[i]) + ": ", this.getImage(0), fHeader[i], startOffset, currentValue.length());
                proposal.setAdditionalProposalInfo(this.getJavaDoc(fHeader[i]));
                completions.add(proposal);
            }
            ++i;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    protected ICompletionProposal[] computeValue(IDocument doc, int startOffset, int offset) throws BadLocationException {
        int index;
        String value = doc.get(startOffset, offset - startOffset);
        int lineNum = doc.getLineOfOffset(startOffset) - 1;
        while ((index = value.indexOf(58)) == -1 || value.length() - 1 != index && value.charAt(index + 1) == '=') {
            int startLine = doc.getLineOffset(lineNum);
            value = doc.get(startLine, offset - startLine);
            --lineNum;
        }
        int length = value.length();
        if (value.regionMatches(true, 0, "Import-Package", 0, Math.min(length, "Import-Package".length()))) {
            return this.handleImportPackageCompletion(value.substring("Import-Package".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Fragment-Host", 0, Math.min(length, "Fragment-Host".length()))) {
            return this.handleFragmentHostCompletion(value.substring("Fragment-Host".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Require-Bundle", 0, Math.min(length, "Require-Bundle".length()))) {
            return this.handleRequireBundleCompletion(value.substring("Require-Bundle".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Export-Package", 0, Math.min(length, "Export-Package".length()))) {
            return this.handleExportPackageCompletion(value.substring("Export-Package".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Bundle-Activator", 0, Math.min(length, "Bundle-Activator".length()))) {
            return this.handleBundleActivatorCompletion(this.removeLeadingSpaces(value.substring("Bundle-Activator".length() + 1)), offset);
        }
        if (value.regionMatches(true, 0, "Bundle-SymbolicName", 0, Math.min(length, "Bundle-SymbolicName".length()))) {
            return this.handleBundleSymbolicNameCompletion(value.substring("Bundle-SymbolicName".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Bundle-RequiredExecutionEnvironment", 0, Math.min(length, "Bundle-RequiredExecutionEnvironment".length()))) {
            return this.handleRequiredExecEnv(value.substring("Bundle-RequiredExecutionEnvironment".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Eclipse-LazyStart", 0, Math.min(length, "Eclipse-LazyStart".length()))) {
            return this.handleTrueFalseValue(value.substring("Eclipse-LazyStart".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Bundle-Name", 0, Math.min(length, "Bundle-Name".length()))) {
            return this.handleBundleNameCompletion(value.substring("Bundle-Name".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Bundle-ActivationPolicy", 0, Math.min(length, "Bundle-ActivationPolicy".length()))) {
            return this.handleBundleActivationPolicyCompletion(value.substring("Bundle-ActivationPolicy".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Eclipse-BuddyPolicy", 0, Math.min(length, "Eclipse-BuddyPolicy".length()))) {
            return this.handleBuddyPolicyCompletion(value.substring("Eclipse-BuddyPolicy".length() + 1), offset);
        }
        if (value.regionMatches(true, 0, "Eclipse-BundleShape", 0, Math.min(length, "Eclipse-BundleShape".length()))) {
            return this.handleEclipseBundleShape(value.substring("Eclipse-BundleShape".length() + 1), offset);
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] handleBundleNameCompletion(String currentValue, int offset) {
        int length = (currentValue = this.removeLeadingSpaces(currentValue)).length();
        if (length == 0) {
            return new ICompletionProposal[]{new TypeCompletionProposal(BAUMAN, null, BAUMAN, offset - length, length), new TypeCompletionProposal(ANISZCZYK, null, ANISZCZYK, offset - length, length), new TypeCompletionProposal(LASOCKI_BICZYSKO, null, LASOCKI_BICZYSKO, offset - length, length), new TypeCompletionProposal(PAWLOWSKI, null, PAWLOWSKI, offset - length, length), new TypeCompletionProposal(MELHEM, null, MELHEM, offset - length, length)};
        }
        int i = 0;
        while (i < fNames.length) {
            StringTokenizer tokenizer = new StringTokenizer(currentValue, " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!fNames[i].regionMatches(true, 0, token, 0, token.length())) continue;
                return new ICompletionProposal[]{new TypeCompletionProposal(fNames[i], null, fNames[i], offset - token.length(), token.length())};
            }
            ++i;
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] handleImportPackageCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet importedBundles;
            HashSet set = (HashSet)this.fHeaders.get("Import-Package");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            if ((importedBundles = (HashSet)this.fHeaders.get("Require-Bundle")) == null) {
                importedBundles = new HashSet(0);
            }
            value = this.removeLeadingSpaces(value);
            int length = value.length();
            set.remove(value);
            ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
            IPluginModelBase[] bases = PluginRegistry.getActiveModels();
            int j = 0;
            while (j < bases.length) {
                BundleDescription desc = bases[j].getBundleDescription();
                if (desc != null && !importedBundles.contains(desc.getSymbolicName())) {
                    ExportPackageDescription[] expPkgs = desc.getExportPackages();
                    int i = 0;
                    while (i < expPkgs.length) {
                        String pkgName = expPkgs[i].getName();
                        if (pkgName.regionMatches(true, 0, value, 0, length) && !set.contains(pkgName)) {
                            completions.add(new TypeCompletionProposal(pkgName, this.getImage(1), pkgName, offset - length, length));
                            set.add(pkgName);
                        }
                        ++i;
                    }
                }
                ++j;
            }
            ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
            this.sortCompletions(proposals);
            return proposals;
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            Object[] validAtts = new String[]{"resolution", "version"};
            Object[] validTypes = new Integer[]{new Integer(4), new Integer(5)};
            return this.handleAttrsAndDirectives(value, this.initializeNewList(validAtts), this.initializeNewList(validTypes), offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("resolution".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"mandatory", "optional"}, new int[]{6, 6}, offset, "RESOLUTION_");
        }
        if ("version".regionMatches(true, 0, attributeValue, 0, "version".length()) && (value = this.removeLeadingSpaces(currentValue.substring(equals + 1))).length() == 0) {
            return new ICompletionProposal[]{new TypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] handleXFriendsCompletion(String value, int offset) {
        ManifestElement[] elems = (ManifestElement[])this.fHeaders.get("Bundle-SymbolicName");
        HashSet<String> set = new HashSet<String>();
        if (elems != null && elems.length > 0) {
            set.add(elems[0].getValue());
        }
        if ((value = this.removeLeadingSpaces(value)).length() == 0) {
            return new ICompletionProposal[]{new TypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
        }
        if (value.charAt(0) == '\"') {
            value = value.substring(1);
        }
        int index = value.lastIndexOf(44);
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken());
        }
        return this.handleBundleCompletions(value.substring(index == -1 ? 0 : index + 1), set, 6, offset, true);
    }

    protected ICompletionProposal[] handleFragmentHostCompletion(String currentValue, int offset) {
        int index = currentValue.lastIndexOf(59);
        if (index == -1) {
            HashMap<String, TypeCompletionProposal> completions = new HashMap<String, TypeCompletionProposal>();
            IPluginModelBase base = PluginRegistry.findModel((IProject)((ManifestEditor)this.fSourcePage.getEditor()).getCommonProject());
            BundleDescription desc = base.getBundleDescription();
            String currentId = desc != null ? desc.getSymbolicName() : null;
            String pluginStart = this.removeLeadingSpaces(currentValue);
            int length = pluginStart.length();
            IPluginModelBase[] bases = PluginRegistry.getActiveModels();
            int i = 0;
            while (i < bases.length) {
                String pluginID;
                desc = bases[i].getBundleDescription();
                if (desc != null && desc.getHost() == null && !completions.containsKey(pluginID = bases[i].getBundleDescription().getSymbolicName()) && pluginID.regionMatches(true, 0, pluginStart, 0, length) && !pluginID.equals(currentId)) {
                    completions.put(pluginID, new TypeCompletionProposal(pluginID, this.getImage(2), pluginID, offset - length, length));
                }
                ++i;
            }
            return completions.values().toArray(new ICompletionProposal[completions.size()]);
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || index > equals) {
            return this.matchValueCompletion(this.removeLeadingSpaces(currentValue.substring(index + 1)), new String[]{"bundle-version"}, new int[]{5}, offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(index + 1));
        if ("bundle-version".regionMatches(true, 0, attributeValue, 0, "bundle-version".length())) {
            return this.getBundleVersionCompletions(currentValue.substring(0, index).trim(), this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] handleRequireBundleCompletion(String currentValue, int offset) {
        String value;
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        String string = value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
        if (comma > semicolon || comma == semicolon) {
            HashSet set = (HashSet)this.fHeaders.get("Require-Bundle");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            return this.handleBundleCompletions(value, set, 2, offset, false);
        }
        int equals = currentValue.lastIndexOf(61);
        if (equals == -1 || semicolon > equals) {
            Object[] validAttrs = new String[]{"bundle-version", "resolution", "visibility"};
            Object[] validTypes = new Integer[]{new Integer(5), new Integer(4), new Integer(4)};
            return this.handleAttrsAndDirectives(value, this.initializeNewList(validAttrs), this.initializeNewList(validTypes), offset);
        }
        String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
        if ("visibility".regionMatches(true, 0, attributeValue, 0, "visibility".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"private", "reexport"}, new int[]{6, 6}, offset, "VISIBILITY_");
        }
        if ("resolution".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            return this.matchValueCompletion(currentValue.substring(equals + 1), new String[]{"mandatory", "optional"}, new int[]{6, 6}, offset, "RESOLUTION_");
        }
        if ("bundle-version".regionMatches(true, 0, attributeValue, 0, "resolution".length())) {
            String pluginId = this.removeLeadingSpaces(currentValue.substring(comma == -1 ? 0 : comma + 1, semicolon));
            return this.getBundleVersionCompletions(pluginId, this.removeLeadingSpaces(currentValue.substring(equals + 1)), offset);
        }
        return new ICompletionProposal[0];
    }

    private ICompletionProposal[] getBundleVersionCompletions(String pluginID, String existingValue, int offset) {
        ModelEntry entry = PluginRegistry.findEntry((String)pluginID);
        if (entry != null) {
            IPluginModelBase[] hosts = entry.getActiveModels();
            ArrayList<TypeCompletionProposal> proposals = new ArrayList<TypeCompletionProposal>(hosts.length);
            int i = 0;
            while (i < hosts.length) {
                String proposalValue = this.getVersionProposal(hosts[i]);
                if (proposalValue.regionMatches(0, existingValue, 0, existingValue.length())) {
                    proposals.add(new TypeCompletionProposal(proposalValue.substring(existingValue.length()), this.getImage(6), proposalValue, offset, 0));
                }
                ++i;
            }
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        if (existingValue.length() == 0) {
            return new ICompletionProposal[]{new TypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
        }
        return new ICompletionProposal[0];
    }

    private String getVersionProposal(IPluginModelBase base) {
        StringBuffer buffer = new StringBuffer("\"");
        BundleDescription desc = base.getBundleDescription();
        if (desc != null) {
            Version version = desc.getVersion();
            buffer.append(version.getMajor());
            buffer.append('.');
            buffer.append(version.getMinor());
            buffer.append('.');
            buffer.append(version.getMicro());
        } else {
            char[] chars = base.getPluginBase().getVersion().toCharArray();
            int periodCount = 0;
            int i = 0;
            while (i < chars.length) {
                if (chars[i] == '.') {
                    if (periodCount == 2) break;
                    ++periodCount;
                }
                buffer.append(chars[i]);
                ++i;
            }
        }
        return buffer.append('\"').toString();
    }

    private ICompletionProposal[] handleBundleCompletions(String value, Collection doNotInclude, int type, int offset, boolean includeFragments) {
        value = this.removeLeadingSpaces(value);
        int length = value.length();
        doNotInclude.remove(value);
        ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
        IPluginModelBase[] bases = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < bases.length) {
            String bundleId;
            BundleDescription desc = bases[i].getBundleDescription();
            if (desc != null && (includeFragments || desc.getHost() == null) && (bundleId = desc.getSymbolicName()).regionMatches(true, 0, value, 0, value.length()) && !doNotInclude.contains(bundleId)) {
                completions.add(new TypeCompletionProposal(bundleId, this.getImage(type), bundleId, offset - length, length));
            }
            ++i;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    protected ICompletionProposal[] handleExportPackageCompletion(String currentValue, int offset) {
        int comma = currentValue.lastIndexOf(44);
        int semicolon = currentValue.lastIndexOf(59);
        ArrayList list = new ArrayList();
        if (!this.insideQuotes(currentValue) && comma > semicolon || comma == semicolon) {
            String value = comma != -1 ? currentValue.substring(comma + 1) : currentValue;
            HashSet set = (HashSet)this.fHeaders.get("Export-Package");
            if (set == null) {
                set = this.parseHeaderForValues(currentValue, offset);
            }
            value = this.removeLeadingSpaces(value);
            this.addPackageCompletions(value, set, offset, list);
        } else {
            int equals;
            String value = currentValue;
            if (comma > 0) {
                do {
                    String prefix;
                    if (this.insideQuotes(prefix = currentValue.substring(0, comma))) continue;
                    value = currentValue.substring(comma + 1);
                    break;
                } while ((comma = currentValue.lastIndexOf(44, comma - 1)) > 0);
            }
            if ((equals = currentValue.lastIndexOf(61)) == -1 || semicolon > equals) {
                Object[] validAttrs = new String[]{"version", "x-internal", "x-friends"};
                Object[] validTypes = new Integer[]{new Integer(5), new Integer(4), new Integer(4)};
                return this.handleAttrsAndDirectives(value, this.initializeNewList(validAttrs), this.initializeNewList(validTypes), offset);
            }
            String attributeValue = this.removeLeadingSpaces(currentValue.substring(semicolon + 1));
            if ("x-friends".regionMatches(true, 0, attributeValue, 0, "x-friends".length())) {
                return this.handleXFriendsCompletion(currentValue.substring(equals + 1), offset);
            }
            if ("x-internal".regionMatches(true, 0, attributeValue, 0, "x-internal".length())) {
                return this.handleTrueFalseValue(currentValue.substring(equals + 1), offset);
            }
            if ("version".regionMatches(true, 0, attributeValue, 0, "version".length()) && (value = this.removeLeadingSpaces(currentValue.substring(equals + 1))).length() == 0) {
                return new ICompletionProposal[]{new TypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
            }
        }
        return list.toArray(new ICompletionProposal[list.size()]);
    }

    protected ICompletionProposal[] handleBundleActivatorCompletion(String currentValue, int offset) {
        ArrayList completions = new ArrayList();
        IProject project = ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
        int startOffset = offset - currentValue.length();
        this.generateTypePackageProposals(currentValue, project, completions, startOffset, 5);
        ICompletionProposal[] proposals = completions.toArray(new ICompletionProposal[completions.size()]);
        this.sortCompletions(proposals);
        return proposals;
    }

    protected ICompletionProposal[] handleBundleSymbolicNameCompletion(String currentValue, int offset) {
        int semicolon = currentValue.indexOf(59);
        if (semicolon != -1) {
            int equals = currentValue.indexOf(61);
            if (equals == -1) {
                int type;
                String attribute = currentValue.substring(semicolon + 1);
                attribute = this.removeLeadingSpaces(attribute);
                Object o = this.fHeaders.get("Bundle-ManifestVersion");
                int n = type = o == null || o.toString().equals("1") ? 5 : 4;
                if ("singleton".regionMatches(true, 0, attribute, 0, attribute.length())) {
                    int length = attribute.length();
                    TypeCompletionProposal proposal = new TypeCompletionProposal("singleton:=", this.getImage(type), "singleton", offset - length, length);
                    proposal.setAdditionalProposalInfo(this.getJavaDoc("SINGLETON_DIRECTIVE"));
                    return new ICompletionProposal[]{proposal};
                }
            } else if (equals > semicolon) {
                return this.handleTrueFalseValue(currentValue.substring(equals + 1), offset);
            }
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] handleBundleActivationPolicyCompletion(String currentValue, int offset) {
        int semicolon = currentValue.lastIndexOf(59);
        if (semicolon == -1) {
            int length;
            String lazyValue = "lazy";
            String value = this.removeLeadingSpaces(currentValue);
            if (lazyValue.regionMatches(0, value, 0, length = value.length())) {
                return new ICompletionProposal[]{new TypeCompletionProposal(lazyValue, null, lazyValue, offset - length, length)};
            }
        } else {
            int equals = currentValue.lastIndexOf(61);
            if (semicolon > equals) {
                Object[] validDirectives = new String[]{"exclude", "include"};
                Object[] validTypes = new Integer[]{new Integer(4), new Integer(4)};
                return this.handleAttrsAndDirectives(currentValue, this.initializeNewList(validDirectives), this.initializeNewList(validTypes), offset);
            }
            int quote = currentValue.lastIndexOf(34);
            if (!this.insideQuotes(currentValue)) {
                if (equals > quote) {
                    return new ICompletionProposal[]{new TypeCompletionProposal("\"\"", this.getImage(6), "\"\"", offset, 0)};
                }
            } else {
                String value = currentValue.substring(quote + 1);
                StringTokenizer parser = new StringTokenizer(value, ",");
                HashSet<String> set = new HashSet<String>();
                while (parser.hasMoreTokens()) {
                    set.add(parser.nextToken().trim());
                }
                int comma = value.lastIndexOf(44);
                if (comma > -1) {
                    value = this.removeLeadingSpaces(value.substring(comma + 1));
                }
                ArrayList proposals = new ArrayList();
                this.addPackageCompletions(value, set, offset, proposals);
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] handleBuddyPolicyCompletion(String currentValue, int offset) {
        String[] validValues = new String[]{"dependent", "global", "registered", "app", "ext", "boot", "parent"};
        int comma = currentValue.lastIndexOf(44);
        if (comma != -1) {
            currentValue = currentValue.substring(comma + 1);
        }
        currentValue = this.removeLeadingSpaces(currentValue);
        ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
        ManifestElement[] elems = (ManifestElement[])this.fHeaders.get("Eclipse-BuddyPolicy");
        HashSet<String> set = new HashSet<String>();
        if (elems != null) {
            int i = 0;
            while (i < elems.length) {
                set.add(elems[i].getValue());
                ++i;
            }
        }
        int length = currentValue.length();
        int i = 0;
        while (i < validValues.length) {
            if (validValues[i].regionMatches(true, 0, currentValue, 0, length) && !set.contains(validValues[i])) {
                completions.add(new TypeCompletionProposal(validValues[i], this.getImage(6), validValues[i], offset - length, length));
            }
            ++i;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    protected ICompletionProposal[] handleRequiredExecEnv(String currentValue, int offset) {
        int comma = currentValue.lastIndexOf(44);
        if (comma != -1) {
            currentValue = currentValue.substring(comma + 1);
        }
        currentValue = this.removeLeadingSpaces(currentValue);
        ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
        HashSet set = (HashSet)this.fHeaders.get("Bundle-RequiredExecutionEnvironment");
        if (set == null) {
            set = new HashSet(0);
        }
        int length = currentValue.length();
        int i = 0;
        while (i < fExecEnvs.length) {
            if (fExecEnvs[i].regionMatches(true, 0, currentValue, 0, length) && !set.contains(fExecEnvs[i])) {
                completions.add(new TypeCompletionProposal(fExecEnvs[i], this.getImage(7), fExecEnvs[i], offset - length, length));
            }
            ++i;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    protected ICompletionProposal[] handleTrueFalseValue(String currentValue, int offset) {
        int length = (currentValue = this.removeLeadingSpaces(currentValue)).length();
        if (length == 0) {
            return new ICompletionProposal[]{new TypeCompletionProposal("true", this.getImage(6), "true", offset, 0), new TypeCompletionProposal("false", this.getImage(6), "false", offset, 0)};
        }
        if (length < 5 && "true".regionMatches(true, 0, currentValue, 0, length)) {
            return new ICompletionProposal[]{new TypeCompletionProposal("true", this.getImage(6), "true", offset - length, length)};
        }
        if (length < 6 && "false".regionMatches(true, 0, currentValue, 0, length)) {
            return new ICompletionProposal[]{new TypeCompletionProposal("false", this.getImage(6), "false", offset - length, length)};
        }
        return new ICompletionProposal[0];
    }

    protected ICompletionProposal[] handleEclipseBundleShape(String currentValue, int offset) {
        currentValue = this.removeLeadingSpaces(currentValue);
        ArrayList<TypeCompletionProposal> completions = new ArrayList<TypeCompletionProposal>();
        int length = currentValue.length();
        String[] values = ICoreConstants.SHAPE_VALUES;
        int i = 0;
        while (i < values.length) {
            if (values[i].regionMatches(true, 0, currentValue, 0, length) && !currentValue.equals(values[i])) {
                completions.add(new TypeCompletionProposal(values[i], this.getImage(6), values[i], offset - length, length));
            }
            ++i;
        }
        return completions.toArray(new ICompletionProposal[completions.size()]);
    }

    protected ICompletionProposal[] matchValueCompletion(String value, String[] attrs, int[] types, int offset) {
        return this.matchValueCompletion(value, attrs, types, offset, "");
    }

    protected ICompletionProposal[] matchValueCompletion(String value, String[] attrs, int[] types, int offset, String prefixCostant) {
        ArrayList<TypeCompletionProposal> list = new ArrayList<TypeCompletionProposal>();
        int length = value.length();
        TypeCompletionProposal proposal = null;
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].regionMatches(true, 0, value, 0, length)) {
                if (types[i] == 5) {
                    proposal = new TypeCompletionProposal(String.valueOf(attrs[i]) + "=", this.getImage(5), attrs[i], offset - length, length);
                    proposal.setAdditionalProposalInfo(this.getJavaDoc(String.valueOf(attrs[i]) + "_ATTRIBUTE"));
                } else if (types[i] == 4) {
                    proposal = new TypeCompletionProposal(String.valueOf(attrs[i]) + ":=", this.getImage(4), attrs[i], offset - length, length);
                    proposal.setAdditionalProposalInfo(this.getJavaDoc(String.valueOf(attrs[i]) + "_DIRECTIVE"));
                } else {
                    proposal = new TypeCompletionProposal(attrs[i], this.getImage(types[i]), attrs[i], offset - length, length);
                    proposal.setAdditionalProposalInfo(this.getJavaDoc(String.valueOf(prefixCostant) + attrs[i]));
                }
                list.add(proposal);
            }
            ++i;
        }
        return list.toArray(new ICompletionProposal[list.size()]);
    }

    protected ICompletionProposal[] handleAttrsAndDirectives(String value, ArrayList attrs, ArrayList types, int offset) {
        String fullValue = this.findFullLine(value, offset, false);
        int semicolon = value.lastIndexOf(59);
        value = this.removeLeadingSpaces(value.substring(semicolon + 1));
        StringTokenizer tokenizer = new StringTokenizer(fullValue, ";");
        tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            int indexOfObject;
            String tokenValue = this.removeLeadingSpaces(tokenizer.nextToken());
            int index = tokenValue.indexOf(61);
            if (index == -1) continue;
            if (tokenValue.charAt(index - 1) == ':') {
                --index;
            }
            if ((indexOfObject = attrs.indexOf(tokenValue = tokenValue.substring(0, index))) < 0) continue;
            attrs.remove(indexOfObject);
            types.remove(indexOfObject);
        }
        return this.matchValueCompletion(value, attrs.toArray(new String[attrs.size()]), this.toIntArray(types), offset);
    }

    private void addPackageCompletions(String value, Set currentPackages, int offset, ArrayList proposals) {
        int length = value.length();
        IProject proj = ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
        if (proj != null) {
            IJavaProject jp = JavaCore.create((IProject)proj);
            IPackageFragment[] frags = PDEJavaHelper.getPackageFragments((IJavaProject)jp, (Collection)currentPackages, (boolean)false);
            int i = 0;
            while (i < frags.length) {
                String name = frags[i].getElementName();
                if (name.regionMatches(true, 0, value, 0, length)) {
                    proposals.add(new TypeCompletionProposal(name, this.getImage(1), name, offset - length, length));
                }
                ++i;
            }
        }
    }

    private HashSet parseHeaderForValues(String currentValue, int offset) {
        HashSet<String> set = new HashSet<String>();
        String fullValue = this.findFullLine(currentValue, offset, true);
        StringTokenizer tokenizer = new StringTokenizer(fullValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String pkgValue = tokenizer.nextToken();
            int index = pkgValue.indexOf(59);
            set.add(index == -1 ? pkgValue.trim() : pkgValue.substring(0, index).trim());
        }
        return set;
    }

    private String findFullLine(String value, int offset, boolean entireHeader) {
        IDocument doc = this.fSourcePage.getDocumentProvider().getDocument((Object)this.fSourcePage.getInputContext().getInput());
        try {
            int line = doc.getLineOfOffset(offset);
            String newValue = "";
            int startOfLine = 0;
            int colon = -1;
            do {
                startOfLine = doc.getLineOffset(line);
            } while (((colon = (newValue = doc.get(offset, doc.getLineLength(line) - offset + startOfLine)).lastIndexOf(58)) == -1 || newValue.length() > colon && newValue.charAt(colon + 1) == '=') && (entireHeader || newValue.indexOf(44) == -1) && doc.getNumberOfLines() != ++line);
            if (colon > 0 && newValue.charAt(colon + 1) != '=') {
                newValue = doc.get(offset, startOfLine - 1 - offset);
            } else {
                int comma = newValue.indexOf(44);
                int parenthesis = newValue.indexOf(34);
                if (parenthesis >= comma || newValue.indexOf(34, parenthesis + 1) <= comma) {
                    newValue = comma != -1 ? newValue.substring(0, comma) : newValue;
                }
            }
            return value.concat(newValue);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private int[] toIntArray(ArrayList list) {
        int[] result = new int[list.size()];
        int i = -1;
        while (++i < result.length) {
            Object o = list.get(i);
            if (!(o instanceof Integer)) {
                return new int[0];
            }
            result[i] = (Integer)o;
        }
        return result;
    }

    protected final ArrayList initializeNewList(Object[] values) {
        ArrayList<Object> list = new ArrayList<Object>(values.length);
        int i = 0;
        while (i < values.length) {
            list.add(values[i]);
            ++i;
        }
        return list;
    }

    private boolean insideQuotes(String value) {
        char[] chars = value.toCharArray();
        int numOfQuotes = 0;
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '\"') {
                ++numOfQuotes;
            }
            ++i;
        }
        int j = numOfQuotes % 2;
        return j == 1;
    }

    public void assistSessionEnded(ContentAssistEvent event) {
        this.fHeaders = null;
    }

    public void assistSessionStarted(ContentAssistEvent event) {
    }

    public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
    }

    public Image getImage(int type) {
        if (type >= 0 && type < 8) {
            if (this.fImages[type] == null) {
                switch (type) {
                    case 0: {
                        this.fImages[type] = PDEPluginImages.DESC_BUILD_VAR_OBJ.createImage();
                        return this.fImages[type];
                    }
                    case 1: {
                        return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_PACKAGE);
                    }
                    case 2: {
                        this.fImages[type] = PDEPluginImages.DESC_PLUGIN_OBJ.createImage();
                        return this.fImages[type];
                    }
                    case 3: {
                        return PDEPluginImages.get(PDEPluginImages.OBJ_DESC_GENERATE_CLASS);
                    }
                    case 5: {
                        this.fImages[type] = PDEPluginImages.DESC_ATT_URI_OBJ.createImage();
                        return this.fImages[type];
                    }
                    case 4: {
                        this.fImages[5] = PDEPluginImages.DESC_ATT_URI_OBJ.createImage();
                        ImageDescriptor[][] imageDescriptorArrayArray = new ImageDescriptor[4][];
                        imageDescriptorArrayArray[0] = new ImageDescriptor[]{PDEPluginImages.DESC_DOC_CO};
                        ImageOverlayIcon icon = new ImageOverlayIcon(this.fImages[5], imageDescriptorArrayArray);
                        this.fImages[type] = icon.createImage();
                        return this.fImages[type];
                    }
                    case 7: {
                        this.fImages[type] = PDEPluginImages.DESC_JAVA_LIB_OBJ.createImage();
                        return this.fImages[type];
                    }
                    case 6: {
                        return null;
                    }
                }
            } else {
                return this.fImages[type];
            }
        }
        return null;
    }

    public void dispose() {
        int i = 0;
        while (i < this.fImages.length) {
            if (this.fImages[i] != null && !this.fImages[i].isDisposed()) {
                this.fImages[i].dispose();
            }
            ++i;
        }
    }

    private String getJavaDoc(String constant) {
        if (this.fJP == null) {
            IProject project = ((PDEFormEditor)this.fSourcePage.getEditor()).getCommonProject();
            this.fJP = JavaCore.create((IProject)project);
        }
        return PDEJavaHelperUI.getOSGIConstantJavaDoc(constant, this.fJP);
    }
}

