/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.ui.MCoreExpression;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuSeparator;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.MenuManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContributionRecord {
    MMenu menuModel;
    MMenuContribution menuContribution;
    ArrayList<MMenuElement> generatedElements = new ArrayList();
    HashSet<MMenuElement> sharedElements = new HashSet();
    MenuManagerRenderer renderer;
    boolean isVisible = true;

    public ContributionRecord(MMenu menuModel, MMenuContribution contribution, MenuManagerRenderer renderer) {
        this.menuModel = menuModel;
        this.menuContribution = contribution;
        this.renderer = renderer;
    }

    public MenuManager getManagerForModel() {
        return this.renderer.getManager(this.menuModel);
    }

    public void updateVisibility(IEclipseContext context) {
        boolean currentVisibility;
        ExpressionContext exprContext = new ExpressionContext(context);
        this.updateIsVisible(exprContext);
        HashSet<ContributionRecord> recentlyUpdated = new HashSet<ContributionRecord>();
        recentlyUpdated.add(this);
        for (MMenuElement item : this.generatedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            item.setVisible(currentVisibility);
        }
        for (MMenuElement item : this.sharedElements) {
            currentVisibility = this.computeVisibility(recentlyUpdated, item, exprContext);
            item.setVisible(currentVisibility);
        }
        this.getManagerForModel().markDirty();
    }

    public void updateIsVisible(ExpressionContext exprContext) {
        this.isVisible = ContributionsAnalyzer.isVisible((MMenuContribution)this.menuContribution, (ExpressionContext)exprContext);
    }

    public boolean computeVisibility(HashSet<ContributionRecord> recentlyUpdated, MMenuElement item, ExpressionContext exprContext) {
        ArrayList<ContributionRecord> list;
        boolean currentVisibility = this.isVisible;
        if ((item instanceof MMenu || item instanceof MMenuSeparator) && (list = this.renderer.getList(item)) != null) {
            Iterator<ContributionRecord> cr = list.iterator();
            while (!currentVisibility && cr.hasNext()) {
                ContributionRecord rec = cr.next();
                if (!recentlyUpdated.contains(rec)) {
                    rec.updateIsVisible(exprContext);
                    recentlyUpdated.add(rec);
                }
                currentVisibility |= rec.isVisible;
            }
        }
        if (currentVisibility && item.getVisibleWhen() instanceof MCoreExpression) {
            boolean val;
            currentVisibility = val = ContributionsAnalyzer.isVisible((MCoreExpression)((MCoreExpression)item.getVisibleWhen()), (ExpressionContext)exprContext);
        }
        return currentVisibility;
    }

    public boolean mergeIntoModel() {
        int idx = ContributionRecord.getIndex(this.menuModel, this.menuContribution.getPositionInParent());
        if (idx == -1) {
            return false;
        }
        for (MMenuElement item : this.menuContribution.getChildren()) {
            MMenu shared;
            MMenuElement copy = (MMenuElement)EcoreUtil.copy((EObject)((EObject)item));
            if (copy instanceof MMenu) {
                shared = this.findExistingMenu(copy.getElementId());
                if (shared == null) {
                    shared = (MMenu)copy;
                    this.renderer.linkElementToContributionRecord(copy, this);
                    this.menuModel.getChildren().add(idx++, copy);
                } else {
                    copy = shared;
                }
                this.sharedElements.add((MMenuElement)shared);
            } else if (copy instanceof MMenuSeparator) {
                shared = this.findExistingSeparator(copy.getElementId());
                if (shared == null) {
                    shared = (MMenuSeparator)copy;
                    this.renderer.linkElementToContributionRecord(copy, this);
                    this.menuModel.getChildren().add(idx++, copy);
                } else {
                    copy = shared;
                }
                this.sharedElements.add((MMenuElement)shared);
            } else {
                this.generatedElements.add(copy);
                this.renderer.linkElementToContributionRecord(copy, this);
                this.menuModel.getChildren().add(idx++, copy);
            }
            if (!(copy instanceof MMenu) && !(copy instanceof MMenuSeparator)) continue;
            ArrayList<ContributionRecord> array = this.renderer.getList(copy);
            array.add(this);
        }
        return true;
    }

    MMenu findExistingMenu(String id) {
        if (id == null) {
            return null;
        }
        for (MMenuElement item : this.menuModel.getChildren()) {
            if (!(item instanceof MMenu) || !id.equals(item.getElementId())) continue;
            return (MMenu)item;
        }
        return null;
    }

    MMenuSeparator findExistingSeparator(String id) {
        if (id == null) {
            return null;
        }
        for (MMenuElement item : this.menuModel.getChildren()) {
            if (!(item instanceof MMenuSeparator) || !id.equals(item.getElementId())) continue;
            return (MMenuSeparator)item;
        }
        return null;
    }

    public void dispose() {
        for (MMenuElement copy : this.generatedElements) {
            this.menuModel.getChildren().remove(copy);
        }
        for (MMenuElement shared : this.sharedElements) {
            ArrayList<ContributionRecord> array = this.renderer.getList(shared);
            array.remove(this);
            if (!array.isEmpty()) continue;
            this.menuModel.getChildren().remove(shared);
        }
    }

    private static int getIndex(MElementContainer<?> menuModel, String positionInParent) {
        String id = null;
        String modifier = null;
        if (positionInParent != null && positionInParent.length() > 0) {
            String[] array = positionInParent.split("=");
            modifier = array[0];
            id = array[1];
        }
        if (id == null) {
            return menuModel.getChildren().size();
        }
        int idx = 0;
        int size = menuModel.getChildren().size();
        while (idx < size) {
            if (id.equals(((MUIElement)menuModel.getChildren().get(idx)).getElementId())) {
                if ("after".equals(modifier)) {
                    ++idx;
                }
                return idx;
            }
            ++idx;
        }
        return id.equals("additions") ? menuModel.getChildren().size() : -1;
    }
}

