/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.model.elements;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public abstract class ViewerInputProvider
implements IViewerInputProvider {
    protected static final Object[] EMPTY = new Object[0];

    public void update(final IViewerInputUpdate update) {
        Job job = new Job("viewer input resolution"){

            protected IStatus run(IProgressMonitor monitor) {
                if (!update.isCanceled()) {
                    ViewerInputProvider.this.retrieveInput(update);
                }
                update.done();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setRule(this.getRule(update));
        job.schedule();
    }

    protected void retrieveInput(IViewerInputUpdate update) {
        if (!update.isCanceled()) {
            IStatus status = Status.OK_STATUS;
            try {
                IPresentationContext context = update.getPresentationContext();
                if (this.supportsContext(context)) {
                    update.setInputElement(this.getViewerInput(update.getElement(), context, update));
                } else {
                    update.setInputElement(update.getElement());
                }
            }
            catch (CoreException e) {
                status = e.getStatus();
            }
            update.setStatus(status);
        }
    }

    protected abstract Object getViewerInput(Object var1, IPresentationContext var2, IViewerUpdate var3) throws CoreException;

    protected boolean supportsContext(IPresentationContext context) {
        return this.supportsContextId(context.getId());
    }

    protected abstract boolean supportsContextId(String var1);

    protected ISchedulingRule getRule(IViewerInputUpdate update) {
        return null;
    }
}

